/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.conversation.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.ConversationParameters;
import org.springframework.webflow.conversation.NoSuchConversationException;
import org.springframework.webflow.conversation.impl.ContainedConversation;

class ConversationContainer
implements Serializable {
    private int maxConversations;
    private List conversations;

    public ConversationContainer(int maxConversations) {
        this.maxConversations = maxConversations;
        this.conversations = new ArrayList();
    }

    public synchronized Conversation createAndAddConversation(ConversationId id, ConversationParameters parameters) {
        ContainedConversation conversation = new ContainedConversation(this, id);
        this.conversations.add(conversation);
        if (this.maxExceeded()) {
            ((Conversation)this.conversations.get(0)).end();
        }
        return conversation;
    }

    public synchronized Conversation getConversation(ConversationId id) throws NoSuchConversationException {
        Iterator it = this.conversations.iterator();
        while (it.hasNext()) {
            ContainedConversation conversation = (ContainedConversation)it.next();
            if (!conversation.getId().equals(id)) continue;
            return conversation;
        }
        throw new NoSuchConversationException(id);
    }

    public synchronized void removeConversation(ConversationId id) {
        Iterator it = this.conversations.iterator();
        while (it.hasNext()) {
            ContainedConversation conversation = (ContainedConversation)it.next();
            if (!conversation.getId().equals(id)) continue;
            it.remove();
            break;
        }
    }

    private boolean maxExceeded() {
        return this.maxConversations > 0 && this.conversations.size() > this.maxConversations;
    }
}

