/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.engine.AnnotatedObject;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AnnotatedAction
extends AnnotatedObject
implements Action {
    public static final String NAME_ATTRIBUTE = "name";
    public static final String METHOD_ATTRIBUTE = "method";
    private Action targetAction;

    public AnnotatedAction(Action targetAction) {
        this.setTargetAction(targetAction);
    }

    public Action getTargetAction() {
        return this.targetAction;
    }

    public void setTargetAction(Action targetAction) {
        Assert.notNull((Object)targetAction, (String)"The targetAction to annotate is required");
        this.targetAction = targetAction;
    }

    public String getName() {
        return this.getAttributeMap().getString(NAME_ATTRIBUTE);
    }

    public void setName(String name) {
        this.getAttributeMap().put(NAME_ATTRIBUTE, name);
    }

    public boolean isNamed() {
        return StringUtils.hasText((String)this.getName());
    }

    public String getMethod() {
        return this.getAttributeMap().getString(METHOD_ATTRIBUTE);
    }

    public void setMethod(String method) {
        this.getAttributeMap().put(METHOD_ATTRIBUTE, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event execute(RequestContext context) throws Exception {
        MutableAttributeMap originalAttributes = this.getAttributeMap();
        try {
            context.setAttributes(this.getAttributeMap());
            Event result = this.getTargetAction().execute(context);
            Event event = this.postProcessResult(result);
            return event;
        }
        finally {
            context.setAttributes(originalAttributes);
        }
    }

    protected Event postProcessResult(Event resultEvent) {
        if (resultEvent == null) {
            return null;
        }
        if (this.isNamed()) {
            String qualifiedId = this.getName() + "." + resultEvent.getId();
            resultEvent = new Event(resultEvent.getSource(), qualifiedId, resultEvent.getAttributes());
        }
        return resultEvent;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("targetAction", (Object)this.getTargetAction()).append("attributes", (Object)this.getAttributeMap()).toString();
    }
}

