/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.ActionList;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.NullViewSelector;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewSelector;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ViewSelection;

public class ViewState
extends TransitionableState {
    private ActionList renderActionList = new ActionList();
    private ViewSelector viewSelector = NullViewSelector.INSTANCE;

    public ViewState(Flow flow, String id) throws IllegalArgumentException {
        super(flow, id);
    }

    public ViewSelector getViewSelector() {
        return this.viewSelector;
    }

    public void setViewSelector(ViewSelector viewSelector) {
        Assert.notNull((Object)viewSelector, (String)"The view selector to make view selections is required");
        this.viewSelector = viewSelector;
    }

    public ActionList getRenderActionList() {
        return this.renderActionList;
    }

    protected ViewSelection doEnter(RequestControlContext context) throws FlowExecutionException {
        if (this.viewSelector.isEntrySelectionRenderable(context)) {
            this.renderActionList.execute(context);
        }
        return this.viewSelector.makeEntrySelection(context);
    }

    public ViewSelection refresh(RequestContext context) throws FlowExecutionException {
        this.renderActionList.execute(context);
        return this.viewSelector.makeRefreshSelection(context);
    }

    protected void appendToString(ToStringCreator creator) {
        creator.append("viewSelector", (Object)this.viewSelector);
        super.appendToString(creator);
    }
}

