/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import java.util.HashMap;
import org.springframework.binding.expression.Expression;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.ViewSelector;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ViewSelection;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;

public class FlowDefinitionRedirectSelector
implements ViewSelector {
    private Expression expression;

    public FlowDefinitionRedirectSelector(Expression expression) {
        this.expression = expression;
    }

    public boolean isEntrySelectionRenderable(RequestContext context) {
        return true;
    }

    public ViewSelection makeEntrySelection(RequestContext context) {
        String flowDefinitionId;
        String encodedRedirect = (String)this.expression.evaluate((Object)context, null);
        if (encodedRedirect == null) {
            throw new IllegalStateException("Flow definition redirect expression evaluated to [null], the expression was " + this.expression);
        }
        int index = encodedRedirect.indexOf(63);
        HashMap<String, String> executionInput = null;
        if (index != -1) {
            flowDefinitionId = encodedRedirect.substring(0, index);
            String[] parameters = StringUtils.delimitedListToStringArray((String)encodedRedirect.substring(index + 1), (String)"&");
            executionInput = new HashMap<String, String>(parameters.length, 1.0f);
            for (int i = 0; i < parameters.length; ++i) {
                String nameAndValue = parameters[i];
                index = nameAndValue.indexOf(61);
                if (index != -1) {
                    executionInput.put(nameAndValue.substring(0, index), nameAndValue.substring(index + 1));
                    continue;
                }
                executionInput.put(nameAndValue, "");
            }
        } else {
            flowDefinitionId = encodedRedirect;
        }
        if (!StringUtils.hasText((String)flowDefinitionId)) {
            flowDefinitionId = context.getFlowExecutionContext().getDefinition().getId();
        }
        return new FlowDefinitionRedirect(flowDefinitionId, executionInput);
    }

    public ViewSelection makeRefreshSelection(RequestContext context) {
        return this.makeEntrySelection(context);
    }
}

