/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.Assert;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationException;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.ConversationParameters;
import org.springframework.webflow.conversation.NoSuchConversationException;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRestorationFailureException;
import org.springframework.webflow.execution.repository.continuation.ContinuationUnmarshalException;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuation;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.continuation.SerializedFlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.support.AbstractConversationFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.FlowExecutionStateRestorer;

public class ClientContinuationFlowExecutionRepository
extends AbstractConversationFlowExecutionRepository {
    private FlowExecutionContinuationFactory continuationFactory = new SerializedFlowExecutionContinuationFactory();

    public ClientContinuationFlowExecutionRepository(FlowExecutionStateRestorer executionStateRestorer) {
        super(executionStateRestorer, new NoOpConversationManager());
    }

    public ClientContinuationFlowExecutionRepository(FlowExecutionStateRestorer executionStateRestorer, ConversationManager conversationManager) {
        super(executionStateRestorer, conversationManager);
    }

    protected FlowExecutionContinuationFactory getContinuationFactory() {
        return this.continuationFactory;
    }

    public void setContinuationFactory(FlowExecutionContinuationFactory continuationFactory) {
        Assert.notNull((Object)continuationFactory, (String)"The continuation factory is required");
        this.continuationFactory = continuationFactory;
    }

    public FlowExecution getFlowExecution(FlowExecutionKey key) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Getting flow execution with key '" + key + "'"));
        }
        FlowExecutionContinuation continuation = this.decode((String)((Object)this.getContinuationId(key)));
        try {
            FlowExecution execution = continuation.unmarshal();
            return this.getExecutionStateRestorer().restoreState(execution, this.getConversationScope(key));
        }
        catch (ContinuationUnmarshalException e) {
            throw new FlowExecutionRestorationFailureException(key, (Exception)((Object)e));
        }
    }

    public void putFlowExecution(FlowExecutionKey key, FlowExecution flowExecution) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Putting flow execution '" + flowExecution + "' into repository with key '" + key + "'"));
        }
        this.putConversationScope(key, flowExecution.getConversationScope());
    }

    protected final Serializable generateContinuationId(FlowExecution flowExecution) {
        return this.encode(flowExecution);
    }

    protected final Serializable parseContinuationId(String encodedId) {
        return encodedId;
    }

    protected Serializable encode(FlowExecution flowExecution) {
        FlowExecutionContinuation continuation = this.continuationFactory.createContinuation(flowExecution);
        return new String(Base64.encodeBase64((byte[])continuation.toByteArray()));
    }

    protected FlowExecutionContinuation decode(String encodedContinuation) {
        byte[] bytes = Base64.decodeBase64((byte[])encodedContinuation.getBytes());
        return this.continuationFactory.createContinuation(bytes);
    }

    private static class NoOpConversationManager
    implements ConversationManager {
        private static final NoOpConversation INSTANCE = new NoOpConversation();

        private NoOpConversationManager() {
        }

        public Conversation beginConversation(ConversationParameters conversationParameters) throws ConversationException {
            return INSTANCE;
        }

        public Conversation getConversation(ConversationId id) throws NoSuchConversationException {
            return INSTANCE;
        }

        public ConversationId parseConversationId(String encodedId) throws ConversationException {
            return NoOpConversation.ID;
        }

        private static class NoOpConversation
        implements Conversation {
            private static final ConversationId ID = new ConversationId(){

                public String toString() {
                    return "NoOpConversation id";
                }
            };

            private NoOpConversation() {
            }

            public ConversationId getId() {
                return ID;
            }

            public void lock() {
            }

            public Object getAttribute(Object name) {
                return CollectionUtils.EMPTY_ATTRIBUTE_MAP;
            }

            public void putAttribute(Object name, Object value) {
            }

            public void removeAttribute(Object name) {
            }

            public void end() {
            }

            public void unlock() {
            }
        }
    }
}

