/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationException;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.ConversationParameters;
import org.springframework.webflow.conversation.NoSuchConversationException;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.BadlyFormattedFlowExecutionKeyException;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;
import org.springframework.webflow.execution.repository.support.AbstractFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.CompositeFlowExecutionKey;
import org.springframework.webflow.execution.repository.support.ConversationBackedFlowExecutionLock;
import org.springframework.webflow.execution.repository.support.FlowExecutionStateRestorer;

public abstract class AbstractConversationFlowExecutionRepository
extends AbstractFlowExecutionRepository {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String SCOPE_ATTRIBUTE = "scope";
    private ConversationManager conversationManager;

    protected AbstractConversationFlowExecutionRepository(FlowExecutionStateRestorer executionStateRestorer, ConversationManager conversationManager) {
        super(executionStateRestorer);
        this.setConversationManager(conversationManager);
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    private void setConversationManager(ConversationManager conversationManager) {
        Assert.notNull((Object)conversationManager, (String)"The conversation manager is required");
        this.conversationManager = conversationManager;
    }

    public FlowExecutionKey generateKey(FlowExecution flowExecution) {
        ConversationParameters parameters = this.createConversationParameters(flowExecution);
        Conversation conversation = this.conversationManager.beginConversation(parameters);
        this.onBegin(conversation);
        CompositeFlowExecutionKey key = new CompositeFlowExecutionKey(conversation.getId(), this.generateContinuationId(flowExecution));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generated new key for flow execution '" + flowExecution + "': '" + key + "'"));
        }
        return key;
    }

    public FlowExecutionKey getNextKey(FlowExecution flowExecution, FlowExecutionKey previousKey) {
        CompositeFlowExecutionKey key = (CompositeFlowExecutionKey)previousKey;
        CompositeFlowExecutionKey nextKey = new CompositeFlowExecutionKey(key.getConversationId(), this.generateContinuationId(flowExecution));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generated next key for flow execution '" + flowExecution + "': '" + nextKey + "'; " + "previous key was '" + key + "'"));
        }
        return nextKey;
    }

    public FlowExecutionLock getLock(FlowExecutionKey key) throws FlowExecutionRepositoryException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Getting lock for flow execution with key '" + key + "'"));
        }
        return new ConversationBackedFlowExecutionLock(this.getConversation(key));
    }

    public abstract FlowExecution getFlowExecution(FlowExecutionKey var1) throws FlowExecutionRepositoryException;

    public abstract void putFlowExecution(FlowExecutionKey var1, FlowExecution var2) throws FlowExecutionRepositoryException;

    public void removeFlowExecution(FlowExecutionKey key) throws FlowExecutionRepositoryException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing flow execution with key '" + key + "' from repository"));
        }
        Conversation conversation = this.getConversation(key);
        conversation.end();
        this.onEnd(conversation);
    }

    public FlowExecutionKey parseFlowExecutionKey(String encodedKey) throws FlowExecutionRepositoryException {
        Serializable continuationId;
        ConversationId conversationId;
        Assert.hasText((String)encodedKey, (String)"The string encoded flow execution key is required");
        String[] keyParts = CompositeFlowExecutionKey.keyParts(encodedKey);
        try {
            conversationId = this.conversationManager.parseConversationId(keyParts[0]);
        }
        catch (ConversationException e) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, "The conversation id '" + keyParts[0] + "' contained in the composite flow execution key '" + encodedKey + "' is invalid", (Throwable)((Object)e));
        }
        try {
            continuationId = this.parseContinuationId(keyParts[1]);
        }
        catch (FlowExecutionRepositoryException e) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, "The continuation id '" + keyParts[1] + "' contained in the composite flow execution key '" + encodedKey + "' is invalid", (Throwable)((Object)e));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Parsed encoded flow execution key '" + encodedKey + "', extracted conversation id '" + conversationId + "' and continuation id '" + continuationId + "'"));
        }
        return new CompositeFlowExecutionKey(conversationId, continuationId);
    }

    protected ConversationParameters createConversationParameters(FlowExecution flowExecution) {
        FlowDefinition flow = flowExecution.getDefinition();
        return new ConversationParameters(flow.getId(), flow.getCaption(), flow.getDescription());
    }

    protected void onBegin(Conversation conversation) {
    }

    protected void onEnd(Conversation conversation) {
    }

    protected ConversationId getConversationId(FlowExecutionKey key) {
        return ((CompositeFlowExecutionKey)key).getConversationId();
    }

    protected Serializable getContinuationId(FlowExecutionKey key) {
        return ((CompositeFlowExecutionKey)key).getContinuationId();
    }

    protected Conversation getConversation(FlowExecutionKey key) throws NoSuchFlowExecutionException {
        try {
            return this.getConversationManager().getConversation(this.getConversationId(key));
        }
        catch (NoSuchConversationException e) {
            throw new NoSuchFlowExecutionException(key, (Exception)((Object)e));
        }
    }

    protected MutableAttributeMap getConversationScope(FlowExecutionKey key) {
        return (MutableAttributeMap)this.getConversation(key).getAttribute(SCOPE_ATTRIBUTE);
    }

    protected void putConversationScope(FlowExecutionKey key, MutableAttributeMap scope) {
        Assert.notNull((Object)scope, (String)"The conversation scope attribute map is required");
        this.getConversation(key).putAttribute(SCOPE_ATTRIBUTE, scope);
    }

    protected abstract Serializable generateContinuationId(FlowExecution var1);

    protected abstract Serializable parseContinuationId(String var1) throws FlowExecutionRepositoryException;
}

