/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.util.Assert;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.core.FlowException;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.ViewSelection;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.RequestParameterInputMapper;
import org.springframework.webflow.executor.ResponseInstruction;

public class FlowExecutorImpl
implements FlowExecutor {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$executor$FlowExecutorImpl == null ? (class$org$springframework$webflow$executor$FlowExecutorImpl = FlowExecutorImpl.class$("org.springframework.webflow.executor.FlowExecutorImpl")) : class$org$springframework$webflow$executor$FlowExecutorImpl));
    private FlowDefinitionLocator definitionLocator;
    private FlowExecutionFactory executionFactory;
    private FlowExecutionRepository executionRepository;
    private AttributeMapper inputMapper = new RequestParameterInputMapper();
    static /* synthetic */ Class class$org$springframework$webflow$executor$FlowExecutorImpl;

    public FlowExecutorImpl(FlowDefinitionLocator definitionLocator, FlowExecutionFactory executionFactory, FlowExecutionRepository executionRepository) {
        Assert.notNull((Object)definitionLocator, (String)"The locator for accessing flow definitions is required");
        Assert.notNull((Object)executionFactory, (String)"The execution factory for creating new flow executions is required");
        Assert.notNull((Object)executionRepository, (String)"The repository for persisting flow executions is required");
        this.definitionLocator = definitionLocator;
        this.executionFactory = executionFactory;
        this.executionRepository = executionRepository;
    }

    public AttributeMapper getInputMapper() {
        return this.inputMapper;
    }

    public void setInputMapper(AttributeMapper inputMapper) {
        this.inputMapper = inputMapper;
    }

    public FlowDefinitionLocator getDefinitionLocator() {
        return this.definitionLocator;
    }

    public FlowExecutionFactory getExecutionFactory() {
        return this.executionFactory;
    }

    public FlowExecutionRepository getExecutionRepository() {
        return this.executionRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseInstruction launch(String flowDefinitionId, ExternalContext context) throws FlowException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Launching flow execution for flow definition '" + flowDefinitionId + "'"));
        }
        ExternalContextHolder.setExternalContext(context);
        try {
            FlowDefinition flowDefinition = this.definitionLocator.getFlowDefinition(flowDefinitionId);
            FlowExecution flowExecution = this.executionFactory.createFlowExecution(flowDefinition);
            ViewSelection selectedView = flowExecution.start(this.createInput(context), context);
            if (flowExecution.isActive()) {
                FlowExecutionKey key = this.executionRepository.generateKey(flowExecution);
                this.executionRepository.putFlowExecution(key, flowExecution);
                ResponseInstruction responseInstruction = new ResponseInstruction(key.toString(), flowExecution, selectedView);
                return responseInstruction;
            }
            ResponseInstruction responseInstruction = new ResponseInstruction(flowExecution, selectedView);
            return responseInstruction;
        }
        finally {
            ExternalContextHolder.setExternalContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseInstruction resume(String flowExecutionKey, String eventId, ExternalContext context) throws FlowException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resuming flow execution with key '" + flowExecutionKey + "' on user event '" + eventId + "'"));
        }
        ExternalContextHolder.setExternalContext(context);
        try {
            ViewSelection selectedView;
            FlowExecution flowExecution;
            FlowExecutionLock lock;
            FlowExecutionKey key;
            block9: {
                key = this.executionRepository.parseFlowExecutionKey(flowExecutionKey);
                lock = this.executionRepository.getLock(key);
                lock.lock();
                try {
                    flowExecution = this.executionRepository.getFlowExecution(key);
                    selectedView = flowExecution.signalEvent(eventId, context);
                    if (!flowExecution.isActive()) break block9;
                    key = this.executionRepository.getNextKey(flowExecution, key);
                    this.executionRepository.putFlowExecution(key, flowExecution);
                    ResponseInstruction responseInstruction = new ResponseInstruction(key.toString(), flowExecution, selectedView);
                    lock.unlock();
                    return responseInstruction;
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
            }
            this.executionRepository.removeFlowExecution(key);
            ResponseInstruction responseInstruction = new ResponseInstruction(flowExecution, selectedView);
            lock.unlock();
            return responseInstruction;
        }
        finally {
            ExternalContextHolder.setExternalContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseInstruction refresh(String flowExecutionKey, ExternalContext context) throws FlowException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Refreshing flow execution with key '" + flowExecutionKey + "'"));
        }
        ExternalContextHolder.setExternalContext(context);
        try {
            FlowExecutionKey key = this.executionRepository.parseFlowExecutionKey(flowExecutionKey);
            FlowExecutionLock lock = this.executionRepository.getLock(key);
            lock.lock();
            try {
                FlowExecution flowExecution = this.executionRepository.getFlowExecution(key);
                ViewSelection selectedView = flowExecution.refresh(context);
                this.executionRepository.putFlowExecution(key, flowExecution);
                ResponseInstruction responseInstruction = new ResponseInstruction(key.toString(), flowExecution, selectedView);
                lock.unlock();
                return responseInstruction;
            }
            catch (Throwable throwable) {
                lock.unlock();
                throw throwable;
            }
        }
        finally {
            ExternalContextHolder.setExternalContext(null);
        }
    }

    protected MutableAttributeMap createInput(ExternalContext context) {
        if (this.inputMapper != null) {
            LocalAttributeMap inputMap = new LocalAttributeMap();
            this.inputMapper.map((Object)context, (Object)inputMap, null);
            return inputMap;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

