/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.jsf;

import org.springframework.util.StringUtils;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.jsf.JsfExternalContext;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractionException;
import org.springframework.webflow.executor.support.RequestParameterFlowExecutorArgumentHandler;

public class FlowNavigationHandlerArgumentExtractor
extends RequestParameterFlowExecutorArgumentHandler {
    private static final String FLOW_ID_PREFIX = "flowId:";
    private String flowIdPrefix = "flowId:";

    public String getFlowIdPrefix() {
        return this.flowIdPrefix;
    }

    public void setFlowIdPrefix(String flowIdPrefix) {
        this.flowIdPrefix = flowIdPrefix;
    }

    public boolean isEventIdPresent(ExternalContext context) {
        return StringUtils.hasText((String)this.getOutcome(context)) || super.isEventIdPresent(context);
    }

    public String extractEventId(ExternalContext context) throws FlowExecutorArgumentExtractionException {
        String outcome = this.getOutcome(context);
        if (StringUtils.hasText((String)outcome)) {
            return outcome;
        }
        return super.extractEventId(context);
    }

    public boolean isFlowIdPresent(ExternalContext context) throws FlowExecutorArgumentExtractionException {
        String outcome = this.getOutcome(context);
        if (outcome != null && outcome.startsWith(this.getFlowIdPrefix())) {
            return true;
        }
        return super.isFlowIdPresent(context);
    }

    public String extractFlowId(ExternalContext context) throws FlowExecutorArgumentExtractionException {
        String outcome = this.getOutcome(context);
        if (StringUtils.hasText((String)outcome)) {
            int index = outcome.indexOf(this.getFlowIdPrefix());
            if (index == -1) {
                throw new FlowExecutorArgumentExtractionException("Unable to extract flow id; make sure the JSF outcome is prefixed with '" + this.getFlowIdPrefix() + "' to launch a new flow execution");
            }
            String flowId = outcome.substring(this.getFlowIdPrefix().length());
            if (!StringUtils.hasText((String)flowId)) {
                throw new FlowExecutorArgumentExtractionException("Unable to extract flow id; make sure the flow id is provided in the outcome string");
            }
            return flowId;
        }
        return super.extractFlowId(context);
    }

    private String getOutcome(ExternalContext context) {
        return ((JsfExternalContext)context).getOutcome();
    }
}

