/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.jsf;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.ViewSelection;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.support.ApplicationView;
import org.springframework.webflow.execution.support.ExternalRedirect;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;
import org.springframework.webflow.execution.support.FlowExecutionRedirect;
import org.springframework.webflow.executor.jsf.FlowExecutionHolder;
import org.springframework.webflow.executor.jsf.FlowExecutionHolderUtils;
import org.springframework.webflow.executor.jsf.FlowFacesUtils;
import org.springframework.webflow.executor.jsf.JsfExternalContext;
import org.springframework.webflow.executor.jsf.ViewIdMapper;
import org.springframework.webflow.executor.support.FlowExecutorArgumentHandler;
import org.springframework.webflow.executor.support.RequestParameterFlowExecutorArgumentHandler;

public class FlowPhaseListener
implements PhaseListener {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private FlowExecutorArgumentHandler argumentHandler = new RequestParameterFlowExecutorArgumentHandler();
    private ViewIdMapper viewIdMapper = new DefaultViewIdMapper();

    public FlowExecutorArgumentHandler getArgumentHandler() {
        return this.argumentHandler;
    }

    public void setArgumentHandler(FlowExecutorArgumentHandler argumentHandler) {
        this.argumentHandler = argumentHandler;
    }

    public ViewIdMapper getViewIdMapper() {
        return this.viewIdMapper;
    }

    public void setViewIdMapper(ViewIdMapper viewIdMapper) {
        this.viewIdMapper = viewIdMapper;
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            ExternalContextHolder.setExternalContext(new JsfExternalContext(event.getFacesContext()));
            this.restoreFlowExecution(event.getFacesContext());
        } else if (event.getPhaseId() == PhaseId.RENDER_RESPONSE && FlowExecutionHolderUtils.isFlowExecutionRestored(event.getFacesContext())) {
            this.prepareResponse(this.getCurrentContext(), FlowExecutionHolderUtils.getFlowExecutionHolder(event.getFacesContext()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPhase(PhaseEvent event) {
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            try {
                if (FlowExecutionHolderUtils.isFlowExecutionChanged(event.getFacesContext())) {
                    this.saveFlowExecution(this.getCurrentContext(), FlowExecutionHolderUtils.getFlowExecutionHolder(event.getFacesContext()));
                }
            }
            finally {
                ExternalContextHolder.setExternalContext(null);
            }
        }
    }

    private JsfExternalContext getCurrentContext() {
        return (JsfExternalContext)ExternalContextHolder.getExternalContext();
    }

    protected void restoreFlowExecution(FacesContext facesContext) {
        JsfExternalContext context = new JsfExternalContext(facesContext);
        if (this.argumentHandler.isFlowExecutionKeyPresent(context)) {
            FlowExecutionRepository repository = this.getRepository(context);
            FlowExecutionKey flowExecutionKey = repository.parseFlowExecutionKey(this.argumentHandler.extractFlowExecutionKey(context));
            FlowExecution flowExecution = repository.getFlowExecution(flowExecutionKey);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loaded existing flow execution from repository with id '" + flowExecutionKey + "'"));
            }
            FlowExecutionHolderUtils.setFlowExecutionHolder(new FlowExecutionHolder(flowExecutionKey, flowExecution), facesContext);
        } else if (this.argumentHandler.isFlowIdPresent(context)) {
            String flowId = this.argumentHandler.extractFlowId(context);
            FlowDefinition flowDefinition = this.getLocator(context).getFlowDefinition(flowId);
            FlowExecution flowExecution = this.getFactory(context).createFlowExecution(flowDefinition);
            FlowExecutionHolder holder = new FlowExecutionHolder(flowExecution);
            FlowExecutionHolderUtils.setFlowExecutionHolder(holder, facesContext);
            ViewSelection selectedView = flowExecution.start(this.createInput(flowExecution, context), context);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Started new flow execution");
            }
            holder.setViewSelection(selectedView);
            holder.markNeedsSave();
        }
    }

    protected LocalAttributeMap createInput(FlowExecution flowExecution, ExternalContext context) {
        return null;
    }

    protected void prepareResponse(JsfExternalContext context, FlowExecutionHolder holder) {
        ViewSelection selectedView;
        if (holder.needsSave()) {
            this.generateKey(context, holder);
        }
        if ((selectedView = holder.getViewSelection()) == null) {
            selectedView = holder.getFlowExecution().refresh(context);
            holder.setViewSelection(selectedView);
        }
        if (selectedView instanceof ApplicationView) {
            this.prepareApplicationView(context.getFacesContext(), holder);
        } else if (selectedView instanceof FlowExecutionRedirect) {
            String url = this.argumentHandler.createFlowExecutionUrl(holder.getFlowExecutionKey().toString(), holder.getFlowExecution(), context);
            this.sendRedirect(url, context);
        } else if (selectedView instanceof ExternalRedirect) {
            String flowExecutionKey = holder.getFlowExecution().isActive() ? holder.getFlowExecutionKey().toString() : null;
            String url = this.argumentHandler.createExternalUrl((ExternalRedirect)holder.getViewSelection(), flowExecutionKey, context);
            this.sendRedirect(url, context);
        } else if (selectedView instanceof FlowDefinitionRedirect) {
            String url = this.argumentHandler.createFlowDefinitionUrl((FlowDefinitionRedirect)holder.getViewSelection(), context);
            this.sendRedirect(url, context);
        }
    }

    protected void prepareApplicationView(FacesContext facesContext, FlowExecutionHolder holder) {
        ApplicationView forward = (ApplicationView)holder.getViewSelection();
        if (forward != null) {
            this.putInto(facesContext.getExternalContext().getRequestMap(), forward.getModel());
            this.updateViewRoot(facesContext, this.viewIdMapper.mapViewId(forward.getViewName()));
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        this.argumentHandler.exposeFlowExecutionContext(holder.getFlowExecutionKey().toString(), holder.getFlowExecution(), requestMap);
    }

    private void updateViewRoot(FacesContext facesContext, String viewId) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot == null || this.hasViewChanged(viewRoot, viewId)) {
            ViewHandler handler = facesContext.getApplication().getViewHandler();
            UIViewRoot view = handler.createView(facesContext, viewId);
            facesContext.setViewRoot(view);
        }
    }

    private boolean hasViewChanged(UIViewRoot viewRoot, String viewId) {
        return !viewRoot.getViewId().equals(viewId);
    }

    private void generateKey(JsfExternalContext context, FlowExecutionHolder holder) {
        FlowExecution flowExecution = holder.getFlowExecution();
        if (flowExecution.isActive()) {
            FlowExecutionKey flowExecutionKey = holder.getFlowExecutionKey();
            FlowExecutionRepository repository = this.getRepository(context);
            flowExecutionKey = flowExecutionKey == null ? repository.generateKey(flowExecution) : repository.getNextKey(flowExecution, flowExecutionKey);
            holder.setFlowExecutionKey(flowExecutionKey);
        }
    }

    protected void saveFlowExecution(JsfExternalContext context, FlowExecutionHolder holder) {
        FlowExecution flowExecution = holder.getFlowExecution();
        FlowExecutionRepository repository = this.getRepository(context);
        if (flowExecution.isActive()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Saving continuation to repository with key " + holder.getFlowExecutionKey()));
            }
            repository.putFlowExecution(holder.getFlowExecutionKey(), flowExecution);
        } else if (holder.getFlowExecutionKey() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Removing execution in repository with key '" + holder.getFlowExecutionKey() + "'"));
            }
            repository.removeFlowExecution(holder.getFlowExecutionKey());
        }
    }

    private void putInto(Map targetMap, Map map) {
        try {
            targetMap.putAll(map);
        }
        catch (UnsupportedOperationException e) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                targetMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private void sendRedirect(String url, JsfExternalContext context) {
        try {
            context.getFacesContext().getExternalContext().redirect(url);
            context.getFacesContext().responseComplete();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not send redirect to " + url);
        }
    }

    private FlowDefinitionLocator getLocator(JsfExternalContext context) {
        return FlowFacesUtils.getDefinitionLocator(context.getFacesContext());
    }

    private FlowExecutionFactory getFactory(JsfExternalContext context) {
        return FlowFacesUtils.getExecutionFactory(context.getFacesContext());
    }

    private FlowExecutionRepository getRepository(JsfExternalContext context) {
        return FlowFacesUtils.getExecutionRepository(context.getFacesContext());
    }

    public static class DefaultViewIdMapper
    implements ViewIdMapper {
        public String mapViewId(String viewName) {
            return viewName;
        }
    }
}

