/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.FileContent;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryHelper;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.ResourceHandler;
import com.jaspersoft.jasperserver.ws.axis2.ResourceHandlerRegistry;
import com.jaspersoft.jasperserver.ws.axis2.ResultAttachments;
import com.jaspersoft.jasperserver.ws.axis2.ServiceRequest;
import com.jaspersoft.jasperserver.ws.axis2.WSException;
import com.jaspersoft.jasperserver.ws.axis2.repository.SubResourceHandler;
import com.jaspersoft.jasperserver.ws.xml.ByteArrayDataSource;
import com.jaspersoft.jasperserver.ws.xml.Marshaller;
import com.jaspersoft.jasperserver.ws.xml.Unmarshaller;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.Attachments;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.MessageSource;
import org.springframework.remoting.jaxrpc.ServletEndpointSupport;

public class ManagementService
extends ServletEndpointSupport
implements RepositoryServiceContext {
    protected static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$ws$axis2$ManagementService == null ? (class$com$jaspersoft$jasperserver$ws$axis2$ManagementService = ManagementService.class$("com.jaspersoft.jasperserver.ws.axis2.ManagementService")) : class$com$jaspersoft$jasperserver$ws$axis2$ManagementService));
    protected static final String START_TOKEN = "img src=\"images/";
    protected static final String END_TOKEN = "\"";
    protected static final String REPORT_UNIT = "ReportUnit";
    protected static final String WS_VERSION = "2.0.1";
    protected static final String BEAN_NAME_REPOSITORY_SERVICE = "repositoryService";
    protected static final String BEAN_NAME_ENGINE_SERVICE = "engineService";
    protected static final String BEAN_NAME_RUN_REPORT_ENGINE_SERVICE = "runReportEngineService";
    protected static final String BEAN_NAME_HANDLER_REGISTRY = "resourceHandlerRegistry";
    private static final String ADHOC_TOPICS = "/adhoc/topics";
    private static final String ADHOC_TEMP = "/adhoc/temp";
    private Locale locale = null;
    private RepositoryService repository;
    private EngineService engine;
    private EngineService runReportEngine;
    private RepositoryHelper repositoryHelper;
    private ResourceHandlerRegistry handlerRegistry;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$ws$axis2$ManagementService;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$service$RepositoryService;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$engine$common$service$EngineService;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$ws$axis2$ResourceHandlerRegistry;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportDataSource;

    protected void onInit() {
        this.setLocale(Locale.getDefault());
        this.repository = this.loadRepository();
        this.engine = this.loadEngineService();
        try {
            this.runReportEngine = this.loadRunReportEngineService();
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (this.runReportEngine == null) {
            this.runReportEngine = this.engine;
        }
        this.repositoryHelper = this.loadRepositoryHelper();
        this.handlerRegistry = this.loadHandlerRegistry();
    }

    protected RepositoryService loadRepository() {
        return (RepositoryService)this.getApplicationContext().getBean(BEAN_NAME_REPOSITORY_SERVICE, class$com$jaspersoft$jasperserver$api$metadata$common$service$RepositoryService == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$RepositoryService = ManagementService.class$("com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$RepositoryService);
    }

    protected EngineService loadEngineService() {
        return (EngineService)this.getApplicationContext().getBean(BEAN_NAME_ENGINE_SERVICE, class$com$jaspersoft$jasperserver$api$engine$common$service$EngineService == null ? (class$com$jaspersoft$jasperserver$api$engine$common$service$EngineService = ManagementService.class$("com.jaspersoft.jasperserver.api.engine.common.service.EngineService")) : class$com$jaspersoft$jasperserver$api$engine$common$service$EngineService);
    }

    protected EngineService loadRunReportEngineService() {
        return (EngineService)this.getApplicationContext().getBean(BEAN_NAME_RUN_REPORT_ENGINE_SERVICE, class$com$jaspersoft$jasperserver$api$engine$common$service$EngineService == null ? (class$com$jaspersoft$jasperserver$api$engine$common$service$EngineService = ManagementService.class$("com.jaspersoft.jasperserver.api.engine.common.service.EngineService")) : class$com$jaspersoft$jasperserver$api$engine$common$service$EngineService);
    }

    protected RepositoryHelper loadRepositoryHelper() {
        return new RepositoryHelper(this.engine);
    }

    protected ResourceHandlerRegistry loadHandlerRegistry() {
        return (ResourceHandlerRegistry)this.getApplicationContext().getBean(BEAN_NAME_HANDLER_REGISTRY, class$com$jaspersoft$jasperserver$ws$axis2$ResourceHandlerRegistry == null ? (class$com$jaspersoft$jasperserver$ws$axis2$ResourceHandlerRegistry = ManagementService.class$("com.jaspersoft.jasperserver.ws.axis2.ResourceHandlerRegistry")) : class$com$jaspersoft$jasperserver$ws$axis2$ResourceHandlerRegistry);
    }

    private static String marshalResponse(OperationResult or) {
        return ManagementService.marshalResponse(or, new HashMap(), false);
    }

    protected static String marshalResponse(OperationResult or, ResultAttachments attachments) {
        return ManagementService.marshalResponse(or, attachments.getAttachmentsData(), attachments.isEncapsulationDime());
    }

    private static String marshalResponse(OperationResult or, Map datasources, boolean isEncapsulationDime) {
        String result = "";
        if (datasources != null) {
            MessageContext msgContext = MessageContext.getCurrentContext();
            Message responseMessage = msgContext.getResponseMessage();
            log.error((Object)("Encapsulation DIME? : " + isEncapsulationDime));
            if (isEncapsulationDime) {
                responseMessage.getAttachmentsImpl().setSendType(3);
            }
            Iterator it = datasources.entrySet().iterator();
            while (it.hasNext()) {
                try {
                    Map.Entry entry = it.next();
                    String name = (String)entry.getKey();
                    DataSource datasource = (DataSource)entry.getValue();
                    log.debug((Object)("Adding attachment: " + name + ", type: " + datasource.getContentType()));
                    DataHandler expectedDH = new DataHandler(datasource);
                    AttachmentPart attachPart = null;
                    attachPart = responseMessage.createAttachmentPart(expectedDH);
                    attachPart.setContentId(name);
                    responseMessage.addAttachmentPart(attachPart);
                }
                catch (Exception ex) {
                    log.error((Object)("caught exception marshalling an OperationResult: " + ex.getMessage()), (Throwable)ex);
                    or.setReturnCode(1);
                    or.setMessage("Error attaching a resource to the SOAP message: " + ex.getMessage());
                }
            }
        }
        try {
            StringWriter xmlStringWriter = new StringWriter();
            Marshaller.marshal((Object)or, (StringWriter)xmlStringWriter);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Has descriptors: " + (or.getResourceDescriptors() == null || or.getResourceDescriptors().size() == 0 ? 0 : or.getResourceDescriptors().size())));
                log.debug((Object)"marshalled response");
                log.debug((Object)xmlStringWriter.toString());
            }
            result = xmlStringWriter.toString();
        }
        catch (Exception ex) {
            log.error((Object)("caught exception marshalling an OperationResult: " + ex.getMessage()), (Throwable)ex);
        }
        return result;
    }

    public String list(String requestXmlString) {
        OperationResult or = new OperationResult();
        or.setVersion(WS_VERSION);
        or.setReturnCode(0);
        try {
            StringReader xmlStringReader = new StringReader(requestXmlString);
            com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request = (com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request)Unmarshaller.unmarshal((Class)(class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request == null ? (class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request = ManagementService.class$("com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request")) : class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request), (StringReader)xmlStringReader);
            this.setLocale(request.getLocale());
            List<ResourceDescriptor> list = null;
            if (request.getResourceDescriptor() == null) {
                list = new ArrayList();
                log.debug((Object)"Null resourceDescriptor");
                if (this.getArgumentValue("LIST_DATASOURCES", request.getArguments()) != null && this.getArgumentValue("LIST_DATASOURCES", request.getArguments()).equals("true")) {
                    FilterCriteria criteria = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportDataSource = ManagementService.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportDataSource));
                    log.debug((Object)"Listing datasources...");
                    List lookups = this.repository.loadClientResources(criteria);
                    if (lookups != null && !lookups.isEmpty()) {
                        Iterator it = lookups.iterator();
                        while (it.hasNext()) {
                            list.add(this.createResourceDescriptor((Resource)it.next()));
                        }
                    }
                } else if (this.getArgumentValue("LIST_RESOURCES", request.getArguments()) != null && this.getArgumentValue("RESOURCE_TYPE", request.getArguments()).equals("REPORT_TYPE")) {
                    log.debug((Object)"Listing all reports...");
                    String parentFolder = this.getArgumentValue("START_FROM_DIRECTORY", request.getArguments());
                    if (parentFolder == null || !parentFolder.startsWith("/")) {
                        parentFolder = "/";
                    }
                    List allSubFolders = this.repository.getAllFolders(null);
                    for (int i = 0; i < allSubFolders.size(); ++i) {
                        String currentFolder = ((Folder)allSubFolders.get(i)).getURIString();
                        FilterCriteria filterCriteria = new FilterCriteria();
                        filterCriteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)currentFolder));
                        List units = this.repository.loadClientResources(filterCriteria);
                        for (int j = 0; j < units.size(); ++j) {
                            Resource currentRs = (Resource)units.get(j);
                            if (currentRs.getResourceType() == null || !currentRs.getResourceType().contains("ReportOptions") && !currentRs.getResourceType().contains(REPORT_UNIT) && !currentRs.getResourceType().contains("AdhocReportUnit")) continue;
                            if ("/".equals(parentFolder)) {
                                if (ADHOC_TOPICS.equals(currentRs.getParentFolder()) || ADHOC_TEMP.equals(currentRs.getParentFolder())) continue;
                                list.add(this.createResourceDescriptor(currentRs));
                                continue;
                            }
                            if (!(currentRs.getURIString() + "/").startsWith(parentFolder + "/") || ADHOC_TOPICS.equals(currentRs.getParentFolder()) || ADHOC_TEMP.equals(currentRs.getParentFolder())) continue;
                            list.add(this.createResourceDescriptor(currentRs));
                        }
                    }
                }
            } else if (request.getResourceDescriptor().getWsType().equals("folder")) {
                log.debug((Object)"List folders");
                list = this.listResources(request.getResourceDescriptor().getUriString());
            } else if (request.getResourceDescriptor().getWsType().equals("reportUnit")) {
                log.debug((Object)"List report units");
                list = this.createResourceDescriptor(request.getResourceDescriptor().getUriString()).getChildren();
            } else {
                log.debug((Object)"Listed nothing");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + list.size() + " things"));
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    ResourceDescriptor rd = (ResourceDescriptor)it.next();
                    log.debug((Object)(rd != null ? rd.getName() : "rd was null"));
                }
            }
            or.setResourceDescriptors(list);
            log.debug((Object)"Marshalling response");
        }
        catch (Exception e) {
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)e);
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
        }
        catch (Throwable e) {
            log.error((Object)("caught exception: " + e.getMessage()), e);
        }
        return ManagementService.marshalResponse(or);
    }

    public List listResources(String uri) throws WSException {
        log.debug((Object)("list for uri: " + uri));
        ArrayList<ResourceDescriptor> returnedMaps = new ArrayList<ResourceDescriptor>();
        List folders = this.getRepository().getSubFolders(null, uri);
        if (folders == null) {
            return returnedMaps;
        }
        for (int i = 0; i < folders.size(); ++i) {
            Resource folderRes = (Resource)folders.get(i);
            returnedMaps.add(this.createResourceDescriptor(folderRes));
        }
        FilterCriteria filterCriteria = new FilterCriteria();
        filterCriteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)uri));
        List units = this.getRepository().loadClientResources(filterCriteria);
        if (units == null) {
            return returnedMaps;
        }
        Iterator it = units.iterator();
        while (units != null && it.hasNext()) {
            Resource fileRes = (Resource)it.next();
            try {
                returnedMaps.add(this.createResourceDescriptor(fileRes));
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
        return returnedMaps;
    }

    public String get(String requestXmlString) {
        OperationResult or = new OperationResult();
        or.setVersion(WS_VERSION);
        or.setReturnCode(0);
        try {
            String resourceURI;
            Resource resource;
            StringReader xmlStringReader = new StringReader(requestXmlString);
            com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request = (com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request)Unmarshaller.unmarshal((Class)(class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request == null ? (class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request = ManagementService.class$("com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request")) : class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request), (StringReader)xmlStringReader);
            this.setLocale(request.getLocale());
            List args = request.getArguments();
            HashMap<String, String> specialOptions = new HashMap<String, String>();
            if (args != null) {
                for (int i = 0; i < args.size(); ++i) {
                    Argument arg = null;
                    if (args.get(i) instanceof Argument) {
                        arg = (Argument)args.get(i);
                    }
                    if (arg == null) continue;
                    specialOptions.put(arg.getName(), arg.getValue());
                }
            }
            if ((resource = this.locateResource(resourceURI = request.getResourceDescriptor().getUriString())) != null) {
                ResourceDescriptor rd = this.createResourceDescriptor(resource, this.processDescriptorOptions(specialOptions));
                log.debug((Object)("Get: " + resourceURI + ", wsType: " + rd.getWsType() + ", resourceType: " + rd.getResourceType()));
                or.getResourceDescriptors().add(rd);
                ResultAttachments attachments = new ResultAttachments();
                attachments.setEncapsulationDime(this.getArgumentValue("USE_DIME_ATTACHMENTS", request.getArguments()) != null);
                ResourceHandler handler = this.getHandlerRegistry().getHandler(rd.getWsType());
                handler.getAttachments(resource, specialOptions, rd, attachments, this);
                return ManagementService.marshalResponse(or, attachments);
            }
            log.warn((Object)("Get: null resourceDescriptor for " + resourceURI));
            or.setReturnCode(2);
            or.setMessage(this.getMessageSource().getMessage("webservices.error.resourceNotFound", null, this.getLocale()));
        }
        catch (Exception e) {
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)e);
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
        }
        log.debug((Object)"Marshalling response");
        return ManagementService.marshalResponse(or);
    }

    public ResourceDescriptor createResourceDescriptor(String uri) throws WSException {
        return this.createResourceDescriptor(uri, null);
    }

    protected ResourceDescriptor createResourceDescriptor(String uri, Map specialOptions) throws WSException {
        Resource res = this.locateResource(uri);
        if (res == null) {
            return null;
        }
        specialOptions = this.processDescriptorOptions(specialOptions);
        return this.createResourceDescriptor(res, specialOptions);
    }

    protected Map processDescriptorOptions(Map specialOptions) {
        if (specialOptions == null) {
            specialOptions = new HashMap<String, Boolean>();
        }
        if (!specialOptions.containsKey("ReportUnitContents")) {
            specialOptions.put("ReportUnitContents", Boolean.TRUE);
        }
        return specialOptions;
    }

    protected Resource locateResource(String uri) throws WSException {
        Folder res = null;
        int sep = uri.lastIndexOf("/");
        if (sep < 0) {
            throw new JSException("jsexception.invalid.uri", new Object[]{uri});
        }
        String name = uri.substring(sep + Folder.SEPARATOR_LENGTH);
        String folderName = uri.substring(0, sep);
        if (folderName.endsWith("_files")) {
            String parentUri = folderName.substring(0, folderName.length() - "_files".length());
            log.warn((Object)("Loading uri: " + parentUri));
            Resource parentRes = this.getRepository().getResource(null, parentUri);
            if (parentRes != null) {
                ResourceDescriptor ruRd = this.createResourceDescriptor(folderName);
                log.warn((Object)("Loaded RU " + res));
                if (ruRd == null) {
                    return null;
                }
                res = this.getRepository().getResource(null, uri);
                log.warn((Object)("Loaded resource " + uri + " " + res));
            }
        }
        if (res == null) {
            if (folderName.length() == 0) {
                folderName = "/";
            }
            FilterCriteria filterCriteria = new FilterCriteria();
            filterCriteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderName));
            filterCriteria.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"name", (Object)name));
            List resources = this.getRepository().loadClientResources(filterCriteria);
            if (resources != null && !resources.isEmpty()) {
                res = (Resource)resources.get(0);
            }
        }
        if (res == null) {
            Folder folder = this.getRepository().getFolder(null, uri);
            if (folder != null) {
                res = folder;
            } else {
                return null;
            }
        }
        return res;
    }

    public ResourceDescriptor createResourceDescriptor(Resource resource) throws WSException {
        return this.createResourceDescriptor(resource, null);
    }

    public ResourceDescriptor createResourceDescriptor(Resource resource, Map specialOptions) throws WSException {
        if (resource instanceof ResourceLookup) {
            throw new JSException("jsexception.resourcelookup.not.a.resource", new Object[]{resource.getClass().getName()});
        }
        ResourceHandler resourceHandler = this.getHandlerRegistry().getHandler(resource);
        if (resourceHandler == null) {
            throw new JRRuntimeException("No resource handler found for class " + resource.getClass().getName());
        }
        return resourceHandler.describe(resource, specialOptions, this);
    }

    public String put(String requestXmlString) {
        OperationResult or = new OperationResult();
        or.setVersion(WS_VERSION);
        or.setReturnCode(0);
        try {
            StringReader xmlStringReader = new StringReader(requestXmlString);
            com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request = (com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request)Unmarshaller.unmarshal((Class)(class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request == null ? (class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request = ManagementService.class$("com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request")) : class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request), (StringReader)xmlStringReader);
            this.setLocale(request.getLocale());
            ResourceDescriptor newDescriptor = request.getResourceDescriptor();
            log.debug((Object)("Put: for " + newDescriptor.getUriString()));
            if (newDescriptor.getUriString() == null || newDescriptor.getUriString().length() == 0) {
                throw new WSException(6, this.getMessageSource().getMessage("webservices.error.noUriGiven", null, this.getLocale()));
            }
            if (newDescriptor.getWsType() == null || newDescriptor.getWsType().length() == 0) {
                throw new WSException(6, this.getMessageSource().getMessage("webservices.error.noTypeGiven", null, this.getLocale()));
            }
            String wsType = newDescriptor.getWsType();
            ResourceHandler handler = this.getHandlerRegistry().getHandler(wsType);
            handler.put(this.makeServiceRequest(request, or));
        }
        catch (WSException e) {
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)e);
            or.setReturnCode(e.getErrorCode());
            or.setMessage(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)e);
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
        }
        log.debug((Object)"Marshalling response");
        return ManagementService.marshalResponse(or);
    }

    protected ServiceRequest makeServiceRequest(final com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request, final OperationResult operationResult) {
        return new ServiceRequest(){

            public RepositoryServiceContext getContext() {
                return ManagementService.this;
            }

            public ResourceDescriptor getRequestDescriptor() {
                return request.getResourceDescriptor();
            }

            public String getRequestArgument(String name) {
                return ManagementService.this.getArgumentValue(name, request.getArguments());
            }

            public OperationResult getResult() {
                return operationResult;
            }
        };
    }

    protected String getArgumentValue(String argumentName, List arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            Argument a = (Argument)arguments.get(i);
            if (!(a.getName() == null ? a.getName() == argumentName : a.getName().equals(argumentName))) continue;
            return a.getValue();
        }
        return null;
    }

    public String delete(String requestXmlString) {
        OperationResult or = new OperationResult();
        or.setVersion(WS_VERSION);
        or.setReturnCode(0);
        try {
            StringReader xmlStringReader = new StringReader(requestXmlString);
            com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request = (com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request)Unmarshaller.unmarshal((Class)(class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request == null ? (class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request = ManagementService.class$("com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request")) : class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request), (StringReader)xmlStringReader);
            this.setLocale(request.getLocale());
            String reportUnitUrl = this.getArgumentValue("MODIFY_REPORTUNIT_URI", request.getArguments());
            if (reportUnitUrl != null && reportUnitUrl.length() > 0) {
                log.debug((Object)("Delete: resource in reportUnit: " + reportUnitUrl));
                ReportUnit reportUnit = (ReportUnit)this.repository.getResource(null, reportUnitUrl);
                if (reportUnit == null) {
                    throw new WSException(3, this.getMessageSource().getMessage("webservices.error.reportUnitNotFound", null, this.getLocale()));
                }
                SubResourceHandler handler = (SubResourceHandler)this.getHandlerRegistry().getHandler((Resource)reportUnit);
                handler.deleteSubResource((Resource)reportUnit, request.getResourceDescriptor(), this);
            } else {
                ResourceDescriptor rd = this.createResourceDescriptor(request.getResourceDescriptor().getUriString());
                if (rd == null) {
                    log.error((Object)("Delete: no resource : " + request.getResourceDescriptor().getUriString()));
                } else {
                    String wsType = rd.getWsType();
                    log.debug((Object)("Delete: resource : " + wsType));
                    ResourceHandler handler = this.getHandlerRegistry().getHandler(wsType);
                    handler.delete(rd, this);
                }
            }
        }
        catch (WSException e) {
            e.printStackTrace();
            log.error((Object)("caught WSException: " + e.getMessage()), (Throwable)e);
            or.setReturnCode(e.getErrorCode());
            or.setMessage(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)e);
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
        }
        log.debug((Object)"Marshalling response");
        return ManagementService.marshalResponse(or);
    }

    public String runReport(String requestXmlString) {
        OperationResult or = new OperationResult();
        or.setVersion(WS_VERSION);
        or.setReturnCode(0);
        HashMap<String, ByteArrayDataSource> attachments = new HashMap<String, ByteArrayDataSource>();
        boolean isEncapsulationDime = false;
        try {
            Resource reportResource;
            StringReader xmlStringReader = new StringReader(requestXmlString);
            com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request = (com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request)Unmarshaller.unmarshal((Class)(class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request == null ? (class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request = ManagementService.class$("com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request")) : class$com$jaspersoft$jasperserver$api$metadata$xml$domain$impl$Request), (StringReader)xmlStringReader);
            this.setLocale(request.getLocale());
            isEncapsulationDime = this.getArgumentValue("USE_DIME_ATTACHMENTS", request.getArguments()) != null;
            ResourceDescriptor reportUnit = request.getResourceDescriptor();
            log.debug((Object)("Run report: resource : " + reportUnit.getUriString()));
            String format = this.getArgumentValue("RUN_OUTPUT_FORMAT", request.getArguments());
            if (format == null) {
                format = "PDF";
            }
            if ((reportResource = this.repository.getResource(null, reportUnit.getUriString())) == null || !(reportResource instanceof ReportUnit)) {
                throw new WSException(2, this.getMessageSource().getMessage("webservices.error.notValidReportUnit", new Object[]{reportUnit.getUriString()}, this.getLocale()));
            }
            Map parameters = new HashMap();
            for (int i = 0; i < reportUnit.getParameters().size(); ++i) {
                ListItem param = (ListItem)reportUnit.getParameters().get(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parameter: " + param.getLabel() + ", value: " + param.getValue()));
                }
                if (param.isIsListItem()) {
                    Collection<Object> col = new ArrayList<Object>();
                    Object currentValue = parameters.get(param.getLabel());
                    if (currentValue != null && currentValue instanceof Collection) {
                        col = (Collection)currentValue;
                    }
                    col.add(param.getValue());
                    parameters.put(param.getLabel(), col);
                    continue;
                }
                parameters.put(param.getLabel(), param.getValue());
            }
            parameters = this.repositoryHelper.convertParameterValues(reportUnit.getUriString(), parameters);
            ReportUnitResult result = (ReportUnitResult)this.runReportEngine.execute(this.createExecutionContext(), (Request)new ReportUnitRequest(reportUnit.getUriString(), parameters));
            if (result == null) {
                throw new WSException(5, this.getMessageSource().getMessage("webservices.error.errorExecutingReportUnit", new Object[]{reportUnit.getUriString()}, this.getLocale()));
            }
            JasperPrint jasperPrint = result.getJasperPrint();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ByteArrayDataSource bads = null;
            if (format.equals("JRPRINT")) {
                log.debug((Object)"Returning JasperPrint");
                JRSaver.saveObject((Object)jasperPrint, (OutputStream)bos);
                bads = new ByteArrayDataSource(bos.toByteArray());
                attachments.put("jasperPrint", bads);
            } else {
                HashMap<String, String> exportParameters = new HashMap<String, String>();
                String value = this.getArgumentValue("PAGE", request.getArguments());
                if (value != null) {
                    exportParameters.put("PAGE", value);
                }
                if ((value = this.getArgumentValue("IMAGES_URI", request.getArguments())) != null) {
                    exportParameters.put("IMAGES_URI", value);
                }
                JRExporter exporter = this.getExporter(format, exportParameters);
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)bos);
                try {
                    exporter.exportReport();
                }
                catch (JRException e) {
                    log.error((Object)e);
                    throw new WSException(4, this.getMessageSource().getMessage("webservices.error.errorExportingReportUnit", new Object[]{e.getMessage()}, this.getLocale()));
                }
                finally {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException ex) {}
                    }
                }
                bads = new ByteArrayDataSource(bos.toByteArray(), this.getContentType(format));
                attachments.put("report", bads);
                this.addAdditionalAttachmentsForReport(jasperPrint, attachments, format, new StringBuffer(new String(bos.toByteArray())));
            }
            return ManagementService.marshalResponse(or, attachments, isEncapsulationDime);
        }
        catch (WSException e) {
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)e);
            or.setReturnCode(e.getErrorCode());
            or.setMessage(e.getMessage());
        }
        catch (Throwable e) {
            log.error((Object)("caught Throwable exception: " + e.getMessage()), e);
            e.printStackTrace(System.out);
            System.out.flush();
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
        }
        return ManagementService.marshalResponse(or, attachments, isEncapsulationDime);
    }

    protected ExecutionContext createExecutionContext() {
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setLocale(this.getLocale());
        context.setTimeZone(TimeZone.getDefault());
        return context;
    }

    public JRExporter getExporter(String type, Map exportParameters) {
        JRPdfExporter exporter = null;
        if (type.equals("PDF")) {
            exporter = new JRPdfExporter();
        } else if (type.equals("HTML")) {
            exporter = new JRHtmlExporter();
            if (exportParameters.get("IMAGES_URI") != null) {
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)("" + exportParameters.get("IMAGES_URI")));
            } else {
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"images/");
            }
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.TRUE);
        } else if (type.equals("XLS")) {
            exporter = new JExcelApiExporter();
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
        } else if (type.equals("CSV")) {
            exporter = new JRCsvExporter();
        } else if (type.equals("XML")) {
            exporter = new JRXmlExporter();
        } else if (type.equals("RTF")) {
            exporter = new JRRtfExporter();
        }
        if (exporter != null && exportParameters.get("PAGE") != null) {
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)new Integer("" + exportParameters.get("PAGE")));
        }
        return exporter;
    }

    public String getContentType(String type) {
        String contentType = null;
        if (type.equals("PDF")) {
            contentType = "application/pdf";
        } else if (type.equals("HTML")) {
            contentType = "text/html";
        } else if (type.equals("XLS")) {
            contentType = "application/xls";
        } else if (type.equals("CSV")) {
            contentType = "application/vnd.ms-excel";
        } else if (type.equals("XML")) {
            contentType = "text/xml";
        } else if (type.equals("RTF")) {
            contentType = "application/rtf";
        }
        return contentType;
    }

    private void addAdditionalAttachmentsForReport(JasperPrint jasperPrint, Map attachments, String format, StringBuffer reportContent) throws WSException {
        if (!format.equals("HTML")) {
            return;
        }
        try {
            List images = this.collectImages(jasperPrint, reportContent);
            Iterator it = images.iterator();
            while (it.hasNext()) {
                FileContent content = (FileContent)it.next();
                log.debug((Object)("Adding image: " + content.getName() + ", type: " + content.getMimeType()));
                ByteArrayDataSource bads = new ByteArrayDataSource(content.getData(), content.getMimeType());
                attachments.put(content.getName(), bads);
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new WSException(4, this.getMessageSource().getMessage("webservices.error.errorAddingImage", new Object[]{e.getMessage()}, this.getLocale()));
        }
    }

    private List collectImages(JasperPrint jasperPrint, StringBuffer sBuf) throws JRException {
        int indexNext;
        int indexEndOfName = 0;
        HashSet<String> imageNames = new HashSet<String>();
        while ((indexNext = sBuf.indexOf(START_TOKEN, indexEndOfName)) >= 0) {
            int indexStartOfName = indexNext + START_TOKEN.length();
            indexEndOfName = sBuf.indexOf(END_TOKEN, indexStartOfName);
            String imageName = sBuf.substring(indexStartOfName, indexEndOfName);
            imageNames.add(imageName);
            ++indexEndOfName;
        }
        ArrayList<JasperPrint> jasperPrintList = new ArrayList<JasperPrint>();
        jasperPrintList.add(jasperPrint);
        byte[] imageData = null;
        String imageMimeType = null;
        ArrayList<FileContent> contents = new ArrayList<FileContent>(imageNames.size());
        Iterator it = imageNames.iterator();
        while (it.hasNext()) {
            String imageName = (String)it.next();
            if ("px".equals(imageName)) {
                JRRenderable pxRenderer = JRImageRenderer.getInstance((String)"net/sf/jasperreports/engine/images/pixel.GIF", (byte)1);
                imageData = pxRenderer.getImageData();
                imageMimeType = "image/gif";
            } else {
                JRPrintImage image = JRHtmlExporter.getImage(jasperPrintList, (String)imageName);
                JRRenderable renderer = image.getRenderer();
                if (renderer.getType() == 1) {
                    renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(image.getWidth(), image.getHeight()), image.getBackcolor());
                }
                imageMimeType = JRTypeSniffer.getImageMimeType((byte)renderer.getImageType());
                imageData = renderer.getImageData();
            }
            FileContent content = new FileContent();
            content.setData(imageData);
            content.setMimeType(imageMimeType);
            content.setName(imageName);
            contents.add(content);
        }
        return contents;
    }

    public org.apache.axis.attachments.AttachmentPart[] getMessageAttachments() {
        MessageContext msgContext = MessageContext.getCurrentContext();
        Message reqMsg = msgContext.getRequestMessage();
        Attachments messageAttachments = reqMsg.getAttachmentsImpl();
        if (null == messageAttachments) {
            log.error((Object)"no attachment support");
            return new org.apache.axis.attachments.AttachmentPart[0];
        }
        int attachmentCount = messageAttachments.getAttachmentCount();
        org.apache.axis.attachments.AttachmentPart[] attachments = new org.apache.axis.attachments.AttachmentPart[attachmentCount];
        try {
            Iterator it = messageAttachments.getAttachments().iterator();
            int count = 0;
            while (it.hasNext()) {
                org.apache.axis.attachments.AttachmentPart part = (org.apache.axis.attachments.AttachmentPart)it.next();
                attachments[count++] = part;
            }
            return attachments;
        }
        catch (AxisFault e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    private void setLocale(String requestedLocale) {
        try {
            if (requestedLocale != null) {
                String language = requestedLocale;
                String country = "";
                if (requestedLocale.indexOf("_") > 0) {
                    language = requestedLocale.substring(0, requestedLocale.indexOf("_"));
                    country = requestedLocale.substring(requestedLocale.indexOf("_") + 1);
                    this.setLocale(new Locale(language, country));
                } else {
                    this.setLocale(new Locale(language));
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)("Unable to get requested locale (" + requestedLocale + ")"));
            this.setLocale(Locale.getDefault());
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    protected MessageSource getMessageSource() {
        return this.getApplicationContext();
    }

    public String getMessage(String messageCode, Object[] args) {
        return this.getMessageSource().getMessage(messageCode, args, this.getLocale());
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public EngineService getEngine() {
        return this.engine;
    }

    public ResourceHandlerRegistry getHandlerRegistry() {
        return this.handlerRegistry;
    }

    public RepositoryHelper getRepositoryHelper() {
        return this.repositoryHelper;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

