/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.repository;

import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.ResourceDataSource;
import com.jaspersoft.jasperserver.ws.axis2.ResultAttachments;
import com.jaspersoft.jasperserver.ws.axis2.WSException;
import com.jaspersoft.jasperserver.ws.axis2.repository.RepositoryResourceHandler;
import java.io.IOException;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.soap.SOAPException;
import org.apache.axis.attachments.AttachmentPart;

public class FileResourceHandler
extends RepositoryResourceHandler {
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource;

    public Class getResourceType() {
        return class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource = FileResourceHandler.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource;
    }

    protected void doDescribe(Resource resource, ResourceDescriptor descriptor, Map arguments, RepositoryServiceContext serviceContext) {
        FileResource fileResource = (FileResource)resource;
        descriptor.setWsType(fileResource.getFileType());
        descriptor.setHasData(fileResource.hasData());
        descriptor.setIsReference(fileResource.isReference());
        if (descriptor.getIsReference()) {
            descriptor.setReferenceUri(fileResource.getReferenceURI());
        }
        String resourceType = fileResource.getFileType();
        if (descriptor.getIsReference()) {
            descriptor.setWsType("reference");
        } else if (resourceType == null) {
            descriptor.setWsType("unknow");
        } else if (resourceType.equals("jrxml")) {
            descriptor.setWsType("jrxml");
        } else if (resourceType.equals("img")) {
            descriptor.setWsType("img");
        } else if (resourceType.equals("font")) {
            descriptor.setWsType("font");
        } else if (resourceType.equals("jar")) {
            descriptor.setWsType("jar");
        } else if (resourceType.equals("prop")) {
            descriptor.setWsType("prop");
        }
    }

    protected void updateResource(Resource resource, ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) throws WSException {
        FileResource fileResource = (FileResource)resource;
        String wsType = descriptor.getWsType();
        if (wsType.equals("reference") || descriptor.getIsReference()) {
            String referenceUri = descriptor.getReferenceUri();
            try {
                serviceContext.getRepository().getResource(null, referenceUri);
            }
            catch (Exception ex) {
                throw new WSException(2, serviceContext.getMessage("webservices.error.resourceNotFoundOrInvalid", new Object[]{referenceUri}));
            }
            fileResource.setReferenceURI(referenceUri);
        } else {
            if (wsType.equals("img")) {
                fileResource.setFileType("img");
            } else if (wsType.equals("font")) {
                fileResource.setFileType("font");
            } else if (wsType.equals("jar")) {
                fileResource.setFileType("jar");
            } else if (wsType.equals("jrxml")) {
                fileResource.setFileType("jrxml");
            } else if (wsType.equals("prop")) {
                fileResource.setFileType("prop");
            }
            if (descriptor.getHasData()) {
                try {
                    AttachmentPart[] parts = serviceContext.getMessageAttachments();
                    if (parts.length >= 1) {
                        DataHandler actualDH = parts[0].getDataHandler();
                        fileResource.readData(actualDH.getInputStream());
                    }
                }
                catch (SOAPException e) {
                    throw new WSException((Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new WSException(e);
                }
            }
        }
    }

    public void getAttachments(Resource resource, Map arguments, ResourceDescriptor descriptor, ResultAttachments attachments, RepositoryServiceContext serviceContext) {
        super.getAttachments(resource, arguments, descriptor, attachments, serviceContext);
        if (arguments.containsKey("NO_ATTACHMENT")) {
            descriptor.setHasData(false);
        } else {
            descriptor.setHasData(true);
            FileResourceData fileData = serviceContext.getRepository().getResourceData(null, descriptor.getUriString());
            ResourceDataSource attachmentSource = new ResourceDataSource("", fileData);
            attachments.addAttachment("attachment", attachmentSource);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

