/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.repository;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.ResourceHandler;
import com.jaspersoft.jasperserver.ws.axis2.ResultAttachments;
import com.jaspersoft.jasperserver.ws.axis2.ServiceRequest;
import com.jaspersoft.jasperserver.ws.axis2.WSException;
import java.util.Map;

public class FolderHandler
implements ResourceHandler {
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$Folder;

    public Class getResourceType() {
        return class$com$jaspersoft$jasperserver$api$metadata$common$domain$Folder == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$Folder = FolderHandler.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.Folder")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$Folder;
    }

    public ResourceDescriptor describe(Resource resource, Map arguments, RepositoryServiceContext serviceContext) {
        Folder folder = (Folder)resource;
        ResourceDescriptor descriptor = new ResourceDescriptor();
        descriptor.setWsType("folder");
        descriptor.setHasData(false);
        descriptor.setUriString(folder.getURIString());
        descriptor.setDescription(folder.getDescription());
        descriptor.setLabel(folder.getLabel());
        descriptor.setName(folder.getName());
        descriptor.setResourceType(folder.getResourceType());
        descriptor.setParentFolder(folder.getParentFolder());
        descriptor.setVersion(folder.getVersion());
        descriptor.setCreationDate(folder.getCreationDate());
        return descriptor;
    }

    public void put(ServiceRequest request) throws WSException {
        ResourceDescriptor descriptor = request.getRequestDescriptor();
        RepositoryService repository = request.getContext().getRepository();
        if (descriptor.getIsNew()) {
            FolderImpl folder = new FolderImpl();
            folder.setName(descriptor.getName());
            folder.setLabel(descriptor.getLabel());
            folder.setDescription(descriptor.getDescription());
            folder.setParentFolder(descriptor.getParentFolder());
            folder.setVersion(-1);
            repository.saveFolder(null, (Folder)folder);
            request.getResult().getResourceDescriptors().add(request.getContext().createResourceDescriptor(folder.getURIString()));
        } else {
            Folder res = repository.getFolder(null, descriptor.getUriString());
            if (res != null) {
                if (res.getLabel() == null || !res.getLabel().equals(descriptor.getLabel())) {
                    res.setLabel(descriptor.getLabel());
                }
                if (res.getDescription() == null || !res.getDescription().equals(descriptor.getDescription())) {
                    res.setDescription(descriptor.getDescription());
                }
                repository.saveFolder(null, res);
                request.getResult().addResourceDescriptor(request.getContext().createResourceDescriptor((Resource)res));
            } else {
                request.getResult().setReturnCode(2);
                request.getResult().setMessage(request.getContext().getMessage("webservices.error.folderNotFound", null));
            }
        }
    }

    public void getAttachments(Resource resource, Map arguments, ResourceDescriptor descriptor, ResultAttachments attachments, RepositoryServiceContext serviceContext) {
    }

    public void delete(ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) throws WSException {
        serviceContext.getRepository().deleteFolder(null, descriptor.getUriString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

