/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.repository;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.InputControlQueryDataRow;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.WSException;
import com.jaspersoft.jasperserver.ws.axis2.repository.RepositoryResourceHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InputControlHandler
extends RepositoryResourceHandler {
    protected static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$ws$axis2$repository$InputControlHandler == null ? (class$com$jaspersoft$jasperserver$ws$axis2$repository$InputControlHandler = InputControlHandler.class$("com.jaspersoft.jasperserver.ws.axis2.repository.InputControlHandler")) : class$com$jaspersoft$jasperserver$ws$axis2$repository$InputControlHandler));
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$InputControl;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$ws$axis2$repository$InputControlHandler;

    public Class getResourceType() {
        return class$com$jaspersoft$jasperserver$api$metadata$common$domain$InputControl == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$InputControl = InputControlHandler.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$InputControl;
    }

    protected void doDescribe(Resource resource, ResourceDescriptor descriptor, Map arguments, RepositoryServiceContext serviceContext) throws WSException {
        InputControl fileResource = (InputControl)resource;
        descriptor.setWsType("inputControl");
        descriptor.setHasData(false);
        descriptor.setIsReference(false);
        descriptor.setMandatory(fileResource.isMandatory());
        descriptor.setReadOnly(fileResource.isReadOnly());
        descriptor.setControlType(fileResource.getType());
        ResourceReference childReference = null;
        if (descriptor.getControlType() == 2) {
            childReference = fileResource.getDataType();
        } else if (descriptor.getControlType() == 3 || descriptor.getControlType() == 8 || descriptor.getControlType() == 6 || descriptor.getControlType() == 10) {
            childReference = fileResource.getListOfValues();
        } else if (descriptor.getControlType() == 4 || descriptor.getControlType() == 9 || descriptor.getControlType() == 7 || descriptor.getControlType() == 11) {
            log.info((Object)("Adding query and columns: " + fileResource.getQueryValueColumn()));
            childReference = fileResource.getQuery();
            descriptor.setQueryValueColumn(fileResource.getQueryValueColumn());
            descriptor.setQueryVisibleColumns(fileResource.getQueryVisibleColumns());
        }
        if (childReference != null) {
            ResourceDescriptor childRd = null;
            if (childReference.isLocal()) {
                childRd = serviceContext.createResourceDescriptor(childReference.getLocalResource());
            } else {
                childRd = new ResourceDescriptor();
                childRd.setWsType("reference");
                childRd.setReferenceUri(childReference.getReferenceURI());
            }
            if (childRd != null) {
                descriptor.getChildren().add(childRd);
            }
        }
        if (arguments != null && arguments.containsKey("IC_GET_QUERY_DATA")) {
            String dsUri = (String)arguments.get("IC_GET_QUERY_DATA");
            List data = this.getInputControlItems(fileResource, dsUri, serviceContext);
            descriptor.setQueryData(data);
        }
    }

    protected List getInputControlItems(InputControl control, String datasourceUri, RepositoryServiceContext serviceContext) throws JSException {
        ResourceReference rf;
        ArrayList<InputControlQueryDataRow> list = new ArrayList<InputControlQueryDataRow>();
        Connection connection = null;
        Query query = null;
        ResourceReference queryRef = control.getQuery();
        query = queryRef.isLocal() ? (Query)queryRef.getLocalResource() : (Query)serviceContext.getRepository().getResource(null, queryRef.getReferenceURI());
        Resource dataSource = null;
        dataSource = datasourceUri != null && datasourceUri.trim().length() > 0 ? serviceContext.getRepository().getResource(null, datasourceUri) : ((rf = query.getDataSource()).isLocal() ? rf.getLocalResource() : serviceContext.getRepository().getResource(null, rf.getReferenceURI()));
        if (dataSource == null) {
            log.error((Object)("Unable to find the datasource " + datasourceUri));
        }
        try {
            if (dataSource instanceof JdbcReportDataSource) {
                HashMap paramValues = new HashMap();
                serviceContext.getEngine().createDataSourceService((ReportDataSource)dataSource).setReportParameterValues(paramValues);
                connection = (Connection)paramValues.get("REPORT_CONNECTION");
            } else if (dataSource instanceof JndiJdbcReportDataSource) {
                JndiJdbcReportDataSource jndiDs = (JndiJdbcReportDataSource)dataSource;
                InitialContext ctx = new InitialContext();
                DataSource sqlDs = (DataSource)ctx.lookup("java:comp/env/" + jndiDs.getJndiName());
                connection = sqlDs.getConnection();
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new JSException((Throwable)ex);
        }
        if (connection != null) {
            PreparedStatement st = null;
            ResultSet rs = null;
            try {
                st = connection.prepareStatement(query.getSql());
                rs = st.executeQuery();
                while (rs.next()) {
                    int i;
                    InputControlQueryDataRow ic = new InputControlQueryDataRow();
                    Object valueColumn = rs.getObject(control.getQueryValueColumn());
                    String[] queryVisibleColumns = control.getQueryVisibleColumns();
                    String[] visibleColumnsValues = new String[queryVisibleColumns.length];
                    for (i = 0; i < visibleColumnsValues.length; ++i) {
                        visibleColumnsValues[i] = rs.getString(queryVisibleColumns[i]);
                    }
                    for (i = 0; i < visibleColumnsValues.length; ++i) {
                        ic.getColumnValues().add(visibleColumnsValues[i] != null ? visibleColumnsValues[i] : "");
                    }
                    ic.setValue(valueColumn);
                    list.add(ic);
                }
            }
            catch (Throwable ex) {
                log.error((Object)ex);
                throw new JSException(ex);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception e) {}
                }
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return list;
    }

    protected void updateResource(Resource resource, ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) throws WSException {
        InputControl inputControl = (InputControl)resource;
        inputControl.setMandatory(descriptor.isMandatory());
        inputControl.setReadOnly(descriptor.isReadOnly());
        inputControl.setType(descriptor.getControlType());
        if (inputControl.getType() == 2) {
            if (descriptor.getChildren().size() == 0) {
                throw new WSException(2, serviceContext.getMessage("webservices.error.missingDataType", null));
            }
            ResourceDescriptor rd = (ResourceDescriptor)descriptor.getChildren().get(0);
            if (rd.getWsType().equals("reference")) {
                inputControl.setDataTypeReference(rd.getReferenceUri());
            } else {
                DataType dataType = (DataType)this.toChildResource(rd, serviceContext);
                inputControl.setDataType(dataType);
            }
        } else if (inputControl.getType() == 3 || inputControl.getType() == 8 || inputControl.getType() == 6 || inputControl.getType() == 10) {
            if (descriptor.getChildren().size() == 0) {
                throw new WSException(2, serviceContext.getMessage("webservices.error.missingLOV", null));
            }
            ResourceDescriptor rd = (ResourceDescriptor)descriptor.getChildren().get(0);
            if (rd.getWsType().equals("reference")) {
                inputControl.setListOfValuesReference(rd.getReferenceUri());
            } else {
                ListOfValues lovResource = (ListOfValues)this.toChildResource(rd, serviceContext);
                inputControl.setListOfValues(lovResource);
            }
        } else if (inputControl.getType() == 4 || inputControl.getType() == 9 || inputControl.getType() == 7 || inputControl.getType() == 11) {
            int i;
            if (descriptor.getChildren().size() == 0) {
                throw new WSException(2, serviceContext.getMessage("webservices.error.missingQuery", null));
            }
            ResourceDescriptor rd = (ResourceDescriptor)descriptor.getChildren().get(0);
            inputControl.setQueryValueColumn(descriptor.getQueryValueColumn());
            String[] visibleColumns = descriptor.getQueryVisibleColumns();
            String[] oldColumns = inputControl.getQueryVisibleColumns();
            if (oldColumns != null) {
                for (i = 0; i < oldColumns.length; ++i) {
                    inputControl.removeQueryVisibleColumn(oldColumns[i]);
                }
            }
            for (i = 0; i < visibleColumns.length; ++i) {
                inputControl.addQueryVisibleColumn(visibleColumns[i]);
            }
            if (rd.getWsType().equals("reference")) {
                inputControl.setQueryReference(rd.getReferenceUri());
            } else {
                Query queryResource = (Query)this.toChildResource(rd, serviceContext);
                inputControl.setQuery(queryResource);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

