/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.repository;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.ResourceHandler;
import com.jaspersoft.jasperserver.ws.axis2.ResultAttachments;
import com.jaspersoft.jasperserver.ws.axis2.ServiceRequest;
import com.jaspersoft.jasperserver.ws.axis2.WSException;
import com.jaspersoft.jasperserver.ws.axis2.repository.SubResourceHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RepositoryResourceHandler
implements ResourceHandler {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$ws$axis2$repository$RepositoryResourceHandler == null ? (class$com$jaspersoft$jasperserver$ws$axis2$repository$RepositoryResourceHandler = RepositoryResourceHandler.class$("com.jaspersoft.jasperserver.ws.axis2.repository.RepositoryResourceHandler")) : class$com$jaspersoft$jasperserver$ws$axis2$repository$RepositoryResourceHandler));
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$ws$axis2$repository$RepositoryResourceHandler;

    public ResourceDescriptor describe(Resource resource, Map arguments, RepositoryServiceContext serviceContext) throws WSException {
        ResourceDescriptor descriptor = new ResourceDescriptor();
        this.setCommonAttributes(resource, descriptor);
        this.doDescribe(resource, descriptor, arguments, serviceContext);
        return descriptor;
    }

    protected void setCommonAttributes(Resource resource, ResourceDescriptor descriptor) {
        descriptor.setUriString(resource.getURIString());
        descriptor.setDescription(resource.getDescription());
        descriptor.setLabel(resource.getLabel());
        descriptor.setName(resource.getName());
        descriptor.setResourceType(resource.getResourceType());
        descriptor.setParentFolder(resource.getParentFolder());
        descriptor.setVersion(resource.getVersion());
        descriptor.setCreationDate(resource.getCreationDate());
    }

    protected abstract void doDescribe(Resource var1, ResourceDescriptor var2, Map var3, RepositoryServiceContext var4) throws WSException;

    public void put(ServiceRequest request) throws WSException {
        ResourceDescriptor descriptor = request.getRequestDescriptor();
        RepositoryServiceContext context = request.getContext();
        RepositoryService repository = context.getRepository();
        OperationResult result = request.getResult();
        Resource parentResource = this.getModifyingParentResource(request);
        if (descriptor.getIsNew()) {
            if (parentResource == null) {
                Resource resource = this.toNewResource(descriptor, context);
                repository.saveResource(null, resource);
                result.getResourceDescriptors().add(context.createResourceDescriptor(resource.getURIString()));
            } else {
                SubResourceHandler parentHandler = (SubResourceHandler)context.getHandlerRegistry().getHandler(parentResource);
                Resource subResource = parentHandler.setSubResource(parentResource, request);
                if (subResource != null) {
                    repository.saveResource(null, parentResource);
                    result.getResourceDescriptors().add(context.createResourceDescriptor(subResource));
                }
            }
        } else if (parentResource == null) {
            log.debug((Object)("Put: modifying " + descriptor.getWsType()));
            Class resourceType = this.getResourceType();
            Resource resource = repository.getResource(null, descriptor.getUriString(), resourceType);
            if (resource == null) {
                result.setReturnCode(2);
                result.setMessage(context.getMessage("webservices.error.resourceNotFound", null));
            } else {
                this.copyToResource(resource, descriptor, context);
                repository.saveResource(null, resource);
                result.getResourceDescriptors().add(context.createResourceDescriptor(resource));
            }
        } else {
            SubResourceHandler parentHandler = (SubResourceHandler)context.getHandlerRegistry().getHandler(parentResource);
            Resource subResource = parentHandler.setSubResource(parentResource, request);
            if (subResource != null) {
                repository.saveResource(null, parentResource);
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("ReportUnitContents", Boolean.TRUE);
                result.getResourceDescriptors().add(context.createResourceDescriptor(parentResource, options));
            }
        }
    }

    protected Resource getModifyingParentResource(ServiceRequest request) throws WSException {
        ReportUnit resource = null;
        String reportUnitUrl = request.getRequestArgument("MODIFY_REPORTUNIT_URI");
        if (reportUnitUrl != null && reportUnitUrl.length() > 0) {
            log.debug((Object)("Put: adding/modifying resource in reportUnit " + reportUnitUrl));
            ReportUnit reportUnit = (ReportUnit)request.getContext().getRepository().getResource(null, reportUnitUrl);
            if (reportUnit == null) {
                throw new WSException(3, request.getContext().getMessage("webservices.error.reportUnitNotFound", null));
            }
            resource = reportUnit;
        }
        return resource;
    }

    protected Resource toNewResource(ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) throws WSException {
        Class resourceType = this.getResourceType();
        Resource resource = serviceContext.getRepository().newResource(null, resourceType);
        resource.setParentFolder(descriptor.getParentFolder());
        resource.setVersion(-1);
        resource.setName(descriptor.getName());
        this.copyToResource(resource, descriptor, serviceContext);
        return resource;
    }

    public void copyToResource(Resource resource, ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) throws WSException {
        resource.setLabel(descriptor.getLabel());
        resource.setDescription(descriptor.getDescription());
        this.updateResource(resource, descriptor, serviceContext);
    }

    protected abstract void updateResource(Resource var1, ResourceDescriptor var2, RepositoryServiceContext var3) throws WSException;

    protected Resource toChildResource(ResourceDescriptor descriptor, RepositoryServiceContext context) throws WSException {
        String childType = descriptor.getWsType();
        RepositoryResourceHandler childHandler = (RepositoryResourceHandler)context.getHandlerRegistry().getHandler(childType);
        return childHandler.toNewResource(descriptor, context);
    }

    public void getAttachments(Resource resource, Map arguments, ResourceDescriptor descriptor, ResultAttachments attachments, RepositoryServiceContext serviceContext) {
    }

    public void delete(ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) throws WSException {
        serviceContext.getRepository().deleteResource(null, descriptor.getUriString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ Class getResourceType();
}

