/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.scheduling;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.ws.axis2.scheduling.ReportJobBeanTraslator;
import com.jaspersoft.jasperserver.ws.axis2.scheduling.ReportSchedulerService;
import com.jaspersoft.jasperserver.ws.scheduling.Job;
import com.jaspersoft.jasperserver.ws.scheduling.JobSummary;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.axis.AxisFault;
import org.springframework.context.i18n.LocaleContextHolder;

public class ReportSchedulerServiceImpl
implements ReportSchedulerService {
    private ReportSchedulingService scheduler;
    private ReportJobBeanTraslator beanTraslator;

    public void deleteJob(long id) throws AxisFault {
        this.scheduler.removeScheduledJob(this.makeExecutionContext(), id);
    }

    public void deleteJobs(long[] ids) throws AxisFault {
        this.scheduler.removeScheduledJobs(this.makeExecutionContext(), ids);
    }

    public Job getJob(long id) throws AxisFault {
        ReportJob reportJob = this.scheduler.getScheduledJob(this.makeExecutionContext(), id);
        if (reportJob == null) {
            throw new JSException("report.scheduling.ws.job.not.found", new Object[]{new Long(id)});
        }
        Job job = this.beanTraslator.toServiceBean(reportJob);
        return job;
    }

    public Job scheduleJob(Job job) throws AxisFault {
        ReportJob reportJob = new ReportJob();
        this.beanTraslator.copy(reportJob, job);
        reportJob.setVersion(-1);
        ReportJob savedJob = this.scheduler.scheduleJob(this.makeExecutionContext(), reportJob);
        Job savedServiceJob = this.beanTraslator.toServiceBean(savedJob);
        return savedServiceJob;
    }

    public Job updateJob(Job job) throws AxisFault {
        ReportJob reportJob = new ReportJob();
        this.beanTraslator.copy(reportJob, job);
        ExecutionContext executionContext = this.makeExecutionContext();
        this.scheduler.updateScheduledJob(executionContext, reportJob);
        ReportJob savedJob = this.scheduler.getScheduledJob(executionContext, reportJob.getId());
        Job savedServiceJob = this.beanTraslator.toServiceBean(savedJob);
        return savedServiceJob;
    }

    public JobSummary[] getAllJobs() throws AxisFault {
        List scheduledJobs = this.scheduler.getScheduledJobs(this.makeExecutionContext());
        return this.toSummaryArray(scheduledJobs);
    }

    public JobSummary[] getReportJobs(String reportURI) throws AxisFault {
        List scheduledJobs = this.scheduler.getScheduledJobs(this.makeExecutionContext(), reportURI);
        return this.toSummaryArray(scheduledJobs);
    }

    protected JobSummary[] toSummaryArray(List reportJobSummaries) {
        JobSummary[] jobs;
        if (reportJobSummaries == null || reportJobSummaries.isEmpty()) {
            jobs = null;
        } else {
            jobs = new JobSummary[reportJobSummaries.size()];
            int idx = 0;
            Iterator it = reportJobSummaries.iterator();
            while (it.hasNext()) {
                ReportJobSummary reportJob = (ReportJobSummary)it.next();
                jobs[idx] = this.beanTraslator.toServiceSummary(reportJob);
                ++idx;
            }
        }
        return jobs;
    }

    protected ExecutionContext makeExecutionContext() {
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        executionContext.setLocale(this.getLocale());
        return executionContext;
    }

    protected Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    public ReportSchedulingService getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ReportSchedulingService scheduler) {
        this.scheduler = scheduler;
    }

    public ReportJobBeanTraslator getBeanTraslator() {
        return this.beanTraslator;
    }

    public void setBeanTraslator(ReportJobBeanTraslator beanTraslator) {
        this.beanTraslator = beanTraslator;
    }
}

