/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.mapping;

import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.support.DefaultConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.SettableExpression;
import org.springframework.binding.mapping.Mapping;
import org.springframework.binding.mapping.RequiredMapping;
import org.springframework.util.Assert;

public class MappingBuilder {
    private ExpressionParser expressionParser;
    private ConversionService conversionService = new DefaultConversionService();
    private Expression sourceExpression;
    private SettableExpression targetExpression;
    private Class sourceType;
    private Class targetType;
    private boolean required;

    public MappingBuilder(ExpressionParser expressionParser) {
        Assert.notNull((Object)expressionParser, (String)"The expression parser is required");
        this.expressionParser = expressionParser;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public MappingBuilder source(String expressionString) {
        this.sourceExpression = this.expressionParser.parseExpression(expressionString);
        return this;
    }

    public MappingBuilder target(String expressionString) {
        this.targetExpression = (SettableExpression)this.expressionParser.parseExpression(expressionString);
        return this;
    }

    public MappingBuilder from(Class sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public MappingBuilder to(Class targetType) {
        this.targetType = targetType;
        return this;
    }

    public MappingBuilder required() {
        this.required = true;
        return this;
    }

    public Mapping value() {
        Assert.notNull((Object)this.sourceExpression, (String)"The source expression must be set at a minimum");
        if (this.targetExpression == null) {
            this.targetExpression = (SettableExpression)this.sourceExpression;
        }
        ConversionExecutor typeConverter = null;
        if (this.sourceType != null) {
            Assert.notNull((Object)this.targetType, (String)"The target type is required when the source type is specified");
            typeConverter = this.conversionService.getConversionExecutor(this.sourceType, this.targetType);
        }
        Mapping result = this.required ? new RequiredMapping(this.sourceExpression, this.targetExpression, typeConverter) : new Mapping(this.sourceExpression, this.targetExpression, typeConverter);
        this.reset();
        return result;
    }

    public void reset() {
        this.sourceExpression = null;
        this.targetExpression = null;
        this.sourceType = null;
        this.targetType = null;
        this.required = false;
    }
}

