/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.mondrian.MondrianAxis;
import com.tonbeller.jpivot.mondrian.MondrianCell;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianQueryAdapter;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.impl.FormatStringParser;
import com.tonbeller.jpivot.olap.query.ResultBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Cell;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.ResourceLimitExceededException;
import mondrian.olap.Result;
import mondrian.olap.ResultLimitExceededException;
import org.apache.log4j.Logger;

public class MondrianResult
extends ResultBase {
    static Logger logger = Logger.getLogger((Class)MondrianResult.class);
    private Result monResult = null;
    private int[] posize;
    private FormatStringParser formatStringParser = new FormatStringParser();

    protected MondrianResult(Result monResult, MondrianModel model) throws ResultLimitExceededException {
        super(model);
        this.monResult = monResult;
        this.initData();
    }

    private void initData() throws ResultLimitExceededException {
        int i;
        List monPositions;
        int cellCountLimit = Integer.getInteger("com.tonbeller.jpivot.mondrian.cell.limit", MondrianModel.CELL_LIMIT_DEFAULT);
        MondrianModel mmodel = (MondrianModel)this.model;
        mondrian.olap.Axis[] monAxes = this.monResult.getAxes();
        int nCells = 1;
        this.posize = new int[monAxes.length];
        for (int i2 = 0; i2 < monAxes.length; ++i2) {
            monPositions = monAxes[i2].getPositions();
            int size = 0;
            Iterator pit = monPositions.iterator();
            while (pit.hasNext()) {
                Position position = (Position)pit.next();
                Iterator mit = position.iterator();
                while (mit.hasNext()) {
                    mmodel.addMember((Member)mit.next());
                }
                ++size;
            }
            mmodel.checkListener();
            this.posize[i2] = size;
            nCells *= size;
        }
        mondrian.olap.Axis monSlicer = this.monResult.getSlicerAxis();
        monPositions = monSlicer.getPositions();
        Iterator pit = monPositions.iterator();
        while (pit.hasNext()) {
            Position position = (Position)pit.next();
            Iterator mit = position.iterator();
            while (mit.hasNext()) {
                mmodel.addMember((Member)mit.next());
            }
            mmodel.checkListener();
        }
        if (logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("initData: nCells=");
            buf.append(nCells);
            logger.debug((Object)buf.toString());
        }
        if (cellCountLimit > 0 && cellCountLimit < nCells) {
            int sliceSize = 1;
            for (int i3 = 0; i3 < monAxes.length - 1; ++i3) {
                sliceSize *= this.posize[i3];
            }
            if (logger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("initData: sliceSize=");
                buf.append(sliceSize);
                buf.append(", cellCountLimit=");
                buf.append(cellCountLimit);
                logger.debug((Object)buf.toString());
            }
            if (sliceSize > cellCountLimit) {
                StringBuffer buf = new StringBuffer(100);
                buf.append("Can not display a single slice, exceeded cell limit(");
                buf.append(cellCountLimit);
                buf.append(") for mdx: ");
                buf.append(((MondrianQueryAdapter)mmodel.getQueryAdapter()).getMonQuery().toString());
                throw new ResourceLimitExceededException(buf.toString());
            }
            int n = cellCountLimit / sliceSize + 1;
            nCells = n * sliceSize;
            if (logger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("initData: cell limit adjusted nCells=");
                buf.append(nCells);
                logger.debug((Object)buf.toString());
            }
        }
        this.axesList = new ArrayList();
        for (int i4 = 0; i4 < monAxes.length; ++i4) {
            this.axesList.add(new MondrianAxis(i4, monAxes[i4], mmodel));
            mmodel.checkListener();
        }
        this.slicer = new MondrianAxis(-1, monSlicer, mmodel);
        int[] iar = new int[monAxes.length];
        for (i = 0; i < monAxes.length; ++i) {
            iar[i] = 0;
        }
        for (i = 0; i < nCells; ++i) {
            Cell monCell = this.monResult.getCell(iar);
            MondrianCell cell = new MondrianCell(monCell, mmodel);
            cell.setFormattedValue(monCell.getFormattedValue(), this.formatStringParser);
            this.aCells.add(cell);
            if (nCells > 1) {
                this.increment(iar);
            }
            if (i % 1000 != 0) continue;
            mmodel.checkListener();
        }
    }

    private void increment(int[] iar) {
        int nn = iar[0] = iar[0] + 1;
        if (iar.length > 1 && nn >= this.posize[0]) {
            iar[0] = 0;
            for (int i = 1; i < iar.length; ++i) {
                int n = i;
                iar[n] = iar[n] + 1;
                int kk = iar[n];
                if (kk < this.posize[i]) break;
                iar[i] = 0;
            }
        }
    }

    public Axis[] getAxes() {
        if (this.monResult == null) {
            return null;
        }
        return this.axesList.toArray(new MondrianAxis[0]);
    }
}

