/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.navigator.hierarchy;

import com.tonbeller.jpivot.navigator.hierarchy.AbstractCategory;
import com.tonbeller.jpivot.navigator.hierarchy.HierarchyItem;
import com.tonbeller.jpivot.navigator.hierarchy.HierarchyNavigator;
import com.tonbeller.jpivot.navigator.member.MemberSelectionModel;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.OlapUtils;
import com.tonbeller.jpivot.olap.navi.ChangeSlicer;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.catedit.Item;
import com.tonbeller.wcf.controller.RequestContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

class SlicerCategory
extends AbstractCategory {
    public SlicerCategory(HierarchyNavigator navi, String name, String icon) throws OlapException {
        super(navi, name, icon);
        Set slicerHiers = OlapUtils.getSlicerHierarchies(navi.getOlapModel());
        Iterator it = slicerHiers.iterator();
        while (it.hasNext()) {
            Hierarchy hier = (Hierarchy)it.next();
            HierarchyItem hi = new HierarchyItem(this, hier);
            this.items.add(hi);
        }
        Collections.sort(this.items);
    }

    public void itemClicked(RequestContext context, HierarchyItem item) {
        MemberSelectionModel selection = new MemberSelectionModel();
        if (this.navi.getSlicerExtension() == null) {
            selection.setMode(0);
        } else {
            selection.setMode(1);
        }
        selection.setOrderedSelection(item.getSlicerSelection());
        this.navi.itemClicked(context, item, selection, false);
    }

    void setSelection(HierarchyItem item, Collection selection) {
        item.setSlicerSelection(selection);
    }

    public boolean isOrderSignificant() {
        return false;
    }

    void prepareApplyChanges() {
    }

    void applyChanges() {
        if (!this.isDirty()) {
            return;
        }
        this.setDirty(false);
        ChangeSlicer slicerExtension = this.navi.getSlicerExtension();
        if (slicerExtension == null) {
            return;
        }
        ArrayList memberList = new ArrayList();
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            HierarchyItem hi = (HierarchyItem)it.next();
            memberList.addAll(hi.getSlicerSelection());
        }
        Member[] memberArr = memberList.toArray(new Member[memberList.size()]);
        slicerExtension.setSlicer(memberArr);
    }

    public boolean isEmptyAllowed() {
        return true;
    }

    String validateSelection(HierarchyItem item, Collection selection) {
        if (selection.size() > 1) {
            Resources res = this.getNavigator().getRes();
            return res.getString("jsp.jpivot.selection.mustSelectOneOrLess");
        }
        return null;
    }

    public void addItem(Item item) {
        super.addItem(item);
        Collections.sort(this.items);
    }

    public boolean isSlicer() {
        return true;
    }
}

