/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war;

import com.jaspersoft.jasperserver.api.common.util.LocaleHelper;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.acegisecurity.context.SecurityContextHolder;

public class UserPreferencesFilter
implements Filter {
    private static String USER_LOCALE_PARAM = "userLocale";
    private static String USER_TIMEZONE_PARAM = "userTimezone";
    private static String USER_NAME = "j_username";
    private static String USER_PASSWORD = "j_newpassword1";
    private int cookieAge;
    UserAuthorityService userService;

    public UserAuthorityService getUserService() {
        return this.userService;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession();
        String userLocale = request.getParameter(USER_LOCALE_PARAM);
        String userTimezone = request.getParameter(USER_TIMEZONE_PARAM);
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            session.removeAttribute("js_uname");
            session.removeAttribute("js_upassword");
        }
        if (session.getAttribute(JasperServerConstImpl.getUserLocaleSessionAttr()) == null && userLocale != null && userLocale.length() > 0) {
            Locale locale = LocaleHelper.getInstance().getLocale(userLocale);
            session.setAttribute(JasperServerConstImpl.getUserLocaleSessionAttr(), (Object)locale);
            Cookie cookie = new Cookie(JasperServerConstImpl.getUserLocaleSessionAttr(), userLocale);
            cookie.setMaxAge(this.cookieAge);
            ((HttpServletResponse)response).addCookie(cookie);
        }
        if (session.getAttribute(JasperServerConstImpl.getUserTimezoneSessionAttr()) == null && userTimezone != null && userTimezone.length() > 0) {
            session.setAttribute(JasperServerConstImpl.getUserTimezoneSessionAttr(), (Object)userTimezone);
            Cookie cookie = new Cookie(JasperServerConstImpl.getUserTimezoneSessionAttr(), userTimezone);
            cookie.setMaxAge(this.cookieAge);
            ((HttpServletResponse)response).addCookie(cookie);
        }
        String userName = request.getParameter(USER_NAME);
        String userNewPassword = request.getParameter(USER_PASSWORD);
        String testFilter = (String)session.getAttribute("js_uname");
        if (testFilter == null) {
            if (userName != null) {
                session.setAttribute("js_uname", (Object)userName);
            }
            if (userNewPassword != null) {
                session.setAttribute("js_upassword", (Object)userNewPassword);
            }
        } else {
            userName = (String)session.getAttribute("js_uname");
            userNewPassword = (String)session.getAttribute("js_upassword");
            if (userNewPassword != null && !"".equals(userNewPassword.trim())) {
                User user = this.userService.getUser(null, userName);
                user.setPassword(userNewPassword);
                this.userService.putUser(null, user);
            }
            session.removeAttribute("js_uname");
            session.removeAttribute("js_upassword");
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public int getCookieAge() {
        return this.cookieAge;
    }

    public void setCookieAge(int cookieAge) {
        this.cookieAge = cookieAge;
    }
}

