/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.dto.DataTypeWrapper;
import com.jaspersoft.jasperserver.war.util.CalendarFormatProvider;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class EditDataTypeAction
extends FormAction {
    private static final String FORM_OBJECT_KEY = "dataType";
    private static final String PARENT_FOLDER_ATTR = "parentFolder";
    private static final String CURRENT_DATATYPE_ATTR = "currentDataType";
    private static final String IS_EDIT = "isEdit";
    private RepositoryService repository;
    private CalendarFormatProvider calendarFormatProvider;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$DataTypeWrapper;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(array$B == null ? (array$B = EditDataTypeAction.class$("[B")) : array$B, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    public EditDataTypeAction() {
        this.setFormObjectClass(class$com$jaspersoft$jasperserver$war$dto$DataTypeWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$DataTypeWrapper = EditDataTypeAction.class$("com.jaspersoft.jasperserver.war.dto.DataTypeWrapper")) : class$com$jaspersoft$jasperserver$war$dto$DataTypeWrapper);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public Object createFormObject(RequestContext context) {
        DataTypeWrapper wrapper;
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        if (context.getFlowScope().get(IS_EDIT) != null) {
            String currentDataType = (String)context.getFlowScope().get(CURRENT_DATATYPE_ATTR);
            DataType dataType = (DataType)this.repository.getResource((ExecutionContext)executionContext, currentDataType);
            if (dataType == null) {
                context.getFlowScope().remove("prevForm");
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{currentDataType});
            }
            wrapper = new DataTypeWrapper(dataType);
            wrapper.setMode((byte)2);
        } else {
            DataType dataType = (DataType)this.repository.newResource((ExecutionContext)executionContext, class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType = EditDataTypeAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.DataType")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType);
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (parentFolder == null || parentFolder.trim().length() == 0) {
                parentFolder = "/";
            }
            dataType.setParentFolder(parentFolder);
            wrapper = new DataTypeWrapper(dataType);
            wrapper.setMode((byte)1);
            FilterCriteria criteria = FilterCriteria.createFilter();
            criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)parentFolder));
            ResourceLookup[] allDataTypes = this.repository.findResource((ExecutionContext)executionContext, criteria);
            wrapper.setAllDataTypes(allDataTypes);
        }
        return wrapper;
    }

    public Event saveDataType(RequestContext context) throws Exception {
        DataTypeWrapper wrapper = (DataTypeWrapper)this.getFormObject(context);
        DataType dataType = wrapper.getDataType();
        switch (dataType.getType()) {
            case 3: {
                String minValue = (String)((Object)dataType.getMinValue());
                String maxValue = (String)((Object)dataType.getMaxValue());
                DateFormat dateFormat = this.getCalendarFormatProvider().getDateFormat();
                if (minValue != null && minValue.length() > 0) {
                    dataType.setMinValue((Comparable)dateFormat.parse(minValue));
                }
                if (maxValue == null || maxValue.length() <= 0) break;
                dataType.setMaxValue((Comparable)dateFormat.parse(maxValue));
                break;
            }
            case 4: {
                String minValue = (String)((Object)dataType.getMinValue());
                String maxValue = (String)((Object)dataType.getMaxValue());
                DateFormat dateFormat = this.getCalendarFormatProvider().getDatetimeFormat();
                if (minValue != null && minValue.length() > 0) {
                    dataType.setMinValue((Comparable)dateFormat.parse(minValue));
                }
                if (maxValue == null || maxValue.length() <= 0) break;
                dataType.setMaxValue((Comparable)dateFormat.parse(maxValue));
            }
        }
        if (wrapper.isStandAloneMode()) {
            try {
                this.repository.saveResource(null, (Resource)wrapper.getDataType());
            }
            catch (JSDuplicateResourceException e) {
                this.getFormErrors(context).rejectValue("dataType.name", "DataTypeValidator.error.duplicate");
                return this.error();
            }
        }
        return this.success();
    }

    public Event setupEditForm(RequestContext context) throws Exception {
        MutableAttributeMap rs = context.getRequestScope();
        rs.put(FORM_OBJECT_KEY, this.getFormObject(context));
        rs.put("calendarDatePattern", (Object)this.getCalendarFormatProvider().getCalendarDatePattern());
        rs.put("calendarDatetimePattern", (Object)this.getCalendarFormatProvider().getCalendarDatetimePattern());
        return this.success();
    }

    public CalendarFormatProvider getCalendarFormatProvider() {
        return this.calendarFormatProvider;
    }

    public void setCalendarFormatProvider(CalendarFormatProvider calendarFormatProvider) {
        this.calendarFormatProvider = calendarFormatProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

