/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.FolderWrapper;
import java.beans.PropertyEditor;
import java.util.List;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class EditFolderAction
extends FormAction {
    private static final String FORM_OBJECT_KEY = "folderWrapper";
    private static final String PARENT_FOLDER_ATTR = "parentFolder";
    private static final String CURRENT_FOLDER_ATTR = "currentFolder";
    private static final String IS_EDIT_FOLDER = "isEdit";
    private RepositoryService repository;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$FolderWrapper;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(array$B == null ? (array$B = EditFolderAction.class$("[B")) : array$B, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    public EditFolderAction() {
        this.setFormObjectClass(class$com$jaspersoft$jasperserver$war$dto$FolderWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$FolderWrapper = EditFolderAction.class$("com.jaspersoft.jasperserver.war.dto.FolderWrapper")) : class$com$jaspersoft$jasperserver$war$dto$FolderWrapper);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public Object createFormObject(RequestContext context) {
        FolderWrapper wrapper;
        if (context.getFlowScope().get(IS_EDIT_FOLDER) != null) {
            ExecutionContextImpl executionContext = new ExecutionContextImpl();
            String currentFolder = (String)context.getFlowScope().get(CURRENT_FOLDER_ATTR);
            Folder folder = this.repository.getFolder((ExecutionContext)executionContext, currentFolder);
            if (folder == null) {
                throw new JSException("jsexception.folder.not.found.at", new Object[]{currentFolder});
            }
            wrapper = new FolderWrapper(folder);
            wrapper.setEdit(true);
        } else {
            FolderImpl folder = new FolderImpl();
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (parentFolder == null || parentFolder.trim().length() == 0) {
                parentFolder = "/";
            }
            folder.setParentFolder(parentFolder);
            wrapper = new FolderWrapper((Folder)folder);
            List folders = this.repository.getSubFolders(JasperServerUtil.getExecutionContext(context), parentFolder);
            wrapper.setAllFolders(folders);
        }
        return wrapper;
    }

    public Event saveFolder(RequestContext context) throws Exception {
        FolderWrapper wrapper = (FolderWrapper)this.getFormObject(context);
        try {
            this.repository.saveFolder(null, wrapper.getActualFolder());
        }
        catch (JSDuplicateResourceException e) {
            this.getFormErrors(context).rejectValue("actualFolder.name", "FolderValidator.error.duplicate");
            return this.error();
        }
        return this.success();
    }

    public Event setupEditForm(RequestContext context) throws Exception {
        MutableAttributeMap rs = context.getRequestScope();
        rs.put(FORM_OBJECT_KEY, this.getFormObject(context));
        return this.success();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

