/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.war.action.ReportDataSourceAction;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.dto.QueryWrapper;
import com.jaspersoft.jasperserver.war.dto.ReportDataSourceWrapper;
import java.beans.PropertyEditor;
import java.util.List;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class EditQueryAction
extends FormAction {
    private static final String DATA_SOURCE_PARENT_TYPE = "query";
    private static final String FORM_OBJECT_KEY = "query";
    private static final String PARENT_FOLDER_ATTR = "parentFolder";
    private static final String CURRENT_QUERY_ATTR = "currentQuery";
    private static final String IS_EDIT = "isEdit";
    private static final String DATASOURCE_OBJECT_KEY = "dataResource";
    private RepositoryService repository;
    private JasperServerConstImpl constants = new JasperServerConstImpl();
    private String queryLanguagesRequestAttrName;
    private String[] queryLanguages;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$QueryWrapper;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$Query;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$BeanReportDataSource;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(array$B == null ? (array$B = EditQueryAction.class$("[B")) : array$B, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    public EditQueryAction() {
        this.setFormObjectClass(class$com$jaspersoft$jasperserver$war$dto$QueryWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$QueryWrapper = EditQueryAction.class$("com.jaspersoft.jasperserver.war.dto.QueryWrapper")) : class$com$jaspersoft$jasperserver$war$dto$QueryWrapper);
        this.setFormObjectName("query");
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public Object createFormObject(RequestContext context) {
        QueryWrapper wrapper;
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        if (context.getFlowScope().get(IS_EDIT) != null) {
            String currentQuery = (String)context.getFlowScope().get(CURRENT_QUERY_ATTR);
            Query query = (Query)this.repository.getResource((ExecutionContext)executionContext, currentQuery);
            if (query == null) {
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{currentQuery});
            }
            wrapper = new QueryWrapper(query);
            wrapper.setMode((byte)2);
        } else {
            Query query = (Query)this.repository.newResource((ExecutionContext)executionContext, class$com$jaspersoft$jasperserver$api$metadata$common$domain$Query == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$Query = EditQueryAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.Query")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$Query);
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (parentFolder == null || parentFolder.trim().length() == 0) {
                parentFolder = "/";
            }
            query.setParentFolder(parentFolder);
            query.setLanguage(this.getQueryLanguages()[0]);
            wrapper = new QueryWrapper(query);
            wrapper.setMode((byte)1);
        }
        return wrapper;
    }

    public Event initAction(RequestContext context) throws Exception {
        MutableAttributeMap rs = context.getRequestScope();
        rs.put("query", this.getFormObject(context));
        return this.success();
    }

    public Event saveQuery(RequestContext context) throws Exception {
        QueryWrapper wrapper = (QueryWrapper)this.getFormObject(context);
        if (wrapper.isStandAloneMode()) {
            try {
                this.repository.saveResource(null, (Resource)wrapper.getQuery());
            }
            catch (JSDuplicateResourceException e) {
                this.getFormErrors(context).rejectValue("query.name", "QueryValidator.error.duplicate");
                return this.error();
            }
        }
        return this.success();
    }

    public Event locateDataSource(RequestContext context) throws Exception {
        QueryWrapper queryWrapper = (QueryWrapper)this.getFormObject(context);
        ResourceReference dsRef = queryWrapper.getQuery().getDataSource();
        ReportDataSourceWrapper rdWrapper = new ReportDataSourceWrapper();
        rdWrapper.setParentType("query");
        rdWrapper.setMode((byte)3);
        if (dsRef == null) {
            EditQueryAction editQueryAction = this;
            rdWrapper.setSource(editQueryAction.constants.getFieldChoiceNone());
            rdWrapper.setReportDataSource(null);
        } else if (dsRef.isLocal()) {
            EditQueryAction editQueryAction = this;
            rdWrapper.setSource(editQueryAction.constants.getFieldChoiceLocal());
            ReportDataSource ds = (ReportDataSource)dsRef.getLocalResource();
            if ((class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource = EditQueryAction.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource).isAssignableFrom(ds.getClass())) {
                EditQueryAction editQueryAction2 = this;
                rdWrapper.setType(editQueryAction2.constants.getJDBCDatasourceType());
            } else if ((class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource = EditQueryAction.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource).isAssignableFrom(ds.getClass())) {
                EditQueryAction editQueryAction3 = this;
                rdWrapper.setType(editQueryAction3.constants.getJNDIDatasourceType());
            } else if ((class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$BeanReportDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$BeanReportDataSource = EditQueryAction.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.BeanReportDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$BeanReportDataSource).isAssignableFrom(ds.getClass())) {
                EditQueryAction editQueryAction4 = this;
                rdWrapper.setType(editQueryAction4.constants.getBeanDatasourceType());
            }
            rdWrapper.setReportDataSource(ds);
        } else {
            EditQueryAction editQueryAction = this;
            rdWrapper.setSource(editQueryAction.constants.getFieldChoiceRepo());
            rdWrapper.setSelectedUri(dsRef.getReferenceURI());
        }
        context.getFlowScope().put(ReportDataSourceAction.getFORM_OBJECT_KEY(), (Object)rdWrapper);
        return this.success();
    }

    public Event saveDatasource(RequestContext context) throws Exception {
        ReportDataSourceWrapper resource = (ReportDataSourceWrapper)context.getFlowScope().get(DATASOURCE_OBJECT_KEY);
        QueryWrapper queryWrapper = (QueryWrapper)this.getFormObject(context);
        EditQueryAction editQueryAction = this;
        if (resource.getSource().equals(editQueryAction.constants.getFieldChoiceRepo())) {
            queryWrapper.getQuery().setDataSourceReference(resource.getSelectedUri());
        } else {
            EditQueryAction editQueryAction2 = this;
            if (resource.getSource().equals(editQueryAction2.constants.getFieldChoiceLocal())) {
                queryWrapper.getQuery().setDataSource(resource.getReportDataSource());
            } else {
                queryWrapper.getQuery().setDataSource((ResourceReference)null);
            }
        }
        return this.success();
    }

    public Event prepareQueryTextEdit(RequestContext context) {
        context.getRequestScope().put(this.getQueryLanguagesRequestAttrName(), (Object)this.getQueryLanguages());
        return this.success();
    }

    public Event validateQuery(RequestContext context) throws Exception {
        Errors errors = this.getFormErrors(context);
        QueryWrapper wrapper = (QueryWrapper)this.getFormObject(context);
        this.getValidator().validate((Object)wrapper, errors);
        List fieldErrors = errors.getFieldErrors();
        if (fieldErrors != null && !fieldErrors.isEmpty()) {
            FieldError error = (FieldError)fieldErrors.get(0);
            String field = error.getField();
            if ("query.name".equals(field) || "query.label".equals(field) || "query.description".equals(field)) {
                return this.result("editQueryForm");
            }
            if ("query.sql".equals(field)) {
                return this.result("editQueryTextForm");
            }
        }
        return this.success();
    }

    public String[] getQueryLanguages() {
        return this.queryLanguages;
    }

    public void setQueryLanguages(String[] queryLanguages) {
        this.queryLanguages = queryLanguages;
    }

    public String getQueryLanguagesRequestAttrName() {
        return this.queryLanguagesRequestAttrName;
    }

    public void setQueryLanguagesRequestAttrName(String queryLanguagesRequestAttrName) {
        this.queryLanguagesRequestAttrName = queryLanguagesRequestAttrName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

