/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.common.domain.LogEvent;
import com.jaspersoft.jasperserver.api.engine.common.service.LoggingService;
import java.util.List;
import org.springframework.context.MessageSource;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class LogEventAction
extends FormAction {
    private LoggingService loggingService;
    private static final String SHOW_ALL_EVENTS = "showAll";
    private static final String SHOW_UNREAD_EVENTS = "showUnread";
    private static final String SHOW_EVENTS = "showEvents";
    private MessageSource messages;
    static /* synthetic */ Class class$java$lang$Long;

    public LoggingService getLoggingService() {
        return this.loggingService;
    }

    public void setLoggingService(LoggingService loggingService) {
        this.loggingService = loggingService;
    }

    public MessageSource getMessages() {
        return this.messages;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public Event getEvents(RequestContext context) throws Exception {
        List events = null;
        String show = (String)context.getFlowScope().get(SHOW_EVENTS);
        events = SHOW_ALL_EVENTS.equals(show) ? this.loggingService.getUserEvents(null) : (SHOW_UNREAD_EVENTS.equals(show) ? this.loggingService.getUnreadEvents(null) : this.loggingService.getUserEvents(null));
        context.getFlowScope().put("events", (Object)events);
        return this.success();
    }

    public Event changeEventsType(RequestContext context) throws Exception {
        String show = context.getRequestParameters().get(SHOW_EVENTS);
        context.getFlowScope().put(SHOW_EVENTS, (Object)show);
        return this.success();
    }

    private long[] getIds(RequestContext context) {
        if (context.getRequestParameters().contains("selectedIds")) {
            Long[] idArray = (Long[])context.getRequestParameters().getArray("selectedIds", class$java$lang$Long == null ? (class$java$lang$Long = LogEventAction.class$("java.lang.Long")) : class$java$lang$Long);
            long[] ids = new long[idArray.length];
            for (int i = 0; i < idArray.length; ++i) {
                ids[i] = idArray[i];
            }
            return ids;
        }
        return null;
    }

    public Event delete(RequestContext context) throws Exception {
        long[] ids = this.getIds(context);
        if (ids != null) {
            this.loggingService.delete(null, ids);
        }
        return this.success();
    }

    public Event markAsRead(RequestContext context) throws Exception {
        long[] ids = this.getIds(context);
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                LogEvent event = this.loggingService.getLogEvent(null, ids[i]);
                if (event.getState() == 2) continue;
                event.setState((byte)2);
                this.loggingService.update(event);
            }
        }
        return this.success();
    }

    public Event markAsUnread(RequestContext context) throws Exception {
        long[] ids = this.getIds(context);
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                LogEvent event = this.loggingService.getLogEvent(null, ids[i]);
                if (event.getState() == 1) continue;
                event.setState((byte)1);
                this.loggingService.update(event);
            }
        }
        return this.success();
    }

    public Event setupViewForm(RequestContext context) throws Exception {
        String id = context.getRequestParameters().get("eventId");
        try {
            LogEvent event = this.loggingService.getLogEvent(null, Long.parseLong(id));
            if (event.getState() == 1) {
                event.setState((byte)2);
                this.loggingService.update(event);
            }
            context.getRequestScope().put("event", (Object)event);
            return this.success();
        }
        catch (NumberFormatException e) {
            return this.error();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

