/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.OlapDataSourceWrapper;
import com.jaspersoft.jasperserver.war.validation.OlapDataSourceValidator;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class OlapDataSourceAction
extends FormAction {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String FORM_OBJECT_KEY = "dataResource";
    private static final String DATASOURCEURI_PARAM = "resource";
    private static final String PARENT_FOLDER_ATTR = "parentFolder";
    private RepositoryService repository;
    private OlapConnectionService olapConnection;
    private JasperServerConstImpl constants = new JasperServerConstImpl();
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$OlapDataSourceWrapper;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportDataSource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JdbcOlapDataSource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JndiJdbcOlapDataSource;

    public OlapDataSourceAction() {
        this.setFormObjectClass(class$com$jaspersoft$jasperserver$war$dto$OlapDataSourceWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$OlapDataSourceWrapper = OlapDataSourceAction.class$("com.jaspersoft.jasperserver.war.dto.OlapDataSourceWrapper")) : class$com$jaspersoft$jasperserver$war$dto$OlapDataSourceWrapper);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
        this.setValidator(new OlapDataSourceValidator());
    }

    public Event initAction(RequestContext context) throws Exception {
        OlapDataSourceWrapper formObject = (OlapDataSourceWrapper)this.getFormObject(context);
        if (formObject.isSubflowMode() && formObject.getAllDatasources() == null) {
            FilterCriteria criteria = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportDataSource = OlapDataSourceAction.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportDataSource));
            ResourceLookup[] lookups = this.repository.findResource(JasperServerUtil.getExecutionContext(context), criteria);
            ArrayList<String> allDataSources = null;
            if (lookups != null && lookups.length != 0) {
                this.log("Found OlapDataSource lookups size=" + lookups.length);
                allDataSources = new ArrayList<String>(lookups.length);
                for (int i = 0; i < lookups.length; ++i) {
                    ResourceLookup dr = lookups[i];
                    allDataSources.add(dr.getURIString());
                }
            }
            formObject.setAllDatasources(allDataSources);
        }
        this.log("Type of datasource=" + formObject.getType() + " Mode=" + formObject.getMode());
        context.getFlowScope().put("constants", (Object)this.constants);
        return this.success();
    }

    public Event handleTypeSelection(RequestContext context) throws Exception {
        OlapDataSourceWrapper formObject = (OlapDataSourceWrapper)this.getFormObject(context);
        Object ds = formObject.getOlapDataSource();
        if (ds == null) {
            this.log("Type=" + formObject.getType());
            OlapDataSourceAction olapDataSourceAction = this;
            ds = formObject.getType().equals(olapDataSourceAction.constants.getJNDIDatasourceType()) ? (JndiJdbcReportDataSource)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource = OlapDataSourceAction.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource) : (JdbcReportDataSource)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource = OlapDataSourceAction.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource);
            formObject.setOlapDataSource((ReportDataSource)ds);
        }
        if ((class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JdbcOlapDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JdbcOlapDataSource = OlapDataSourceAction.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.JdbcOlapDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JdbcOlapDataSource).isAssignableFrom(ds.getClass())) {
            OlapDataSourceAction olapDataSourceAction = this;
            if (formObject.getType().equals(olapDataSourceAction.constants.getJNDIDatasourceType())) {
                JndiJdbcReportDataSource jndiSource = (JndiJdbcReportDataSource)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource = OlapDataSourceAction.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource);
                jndiSource.setParentFolder(ds.getParentFolder());
                jndiSource.setName(ds.getName());
                jndiSource.setLabel(ds.getLabel());
                jndiSource.setDescription(ds.getDescription());
                jndiSource.setVersion(ds.getVersion());
                formObject.setOlapDataSource((ReportDataSource)jndiSource);
            }
        } else {
            OlapDataSourceAction olapDataSourceAction = this;
            if (formObject.getType().equals(olapDataSourceAction.constants.getJDBCDatasourceType())) {
                JdbcReportDataSource jdbcSource = (JdbcReportDataSource)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource = OlapDataSourceAction.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource);
                jdbcSource.setParentFolder(ds.getParentFolder());
                jdbcSource.setName(ds.getName());
                jdbcSource.setLabel(ds.getLabel());
                jdbcSource.setDescription(ds.getDescription());
                jdbcSource.setVersion(ds.getVersion());
                formObject.setOlapDataSource((ReportDataSource)jdbcSource);
            }
        }
        return this.success();
    }

    public Event saveLookup(RequestContext context) throws Exception {
        OlapDataSourceWrapper formObject = (OlapDataSourceWrapper)this.getFormObject(context);
        this.log("user selected a reusable OlapDataSource");
        String selectedUri = formObject.getSelectedUri();
        Resource resource = this.repository.getResource(null, selectedUri);
        formObject.setOlapDataSource((ReportDataSource)resource);
        formObject.setSelectedUri(selectedUri);
        return this.success();
    }

    public Event saveDatasource(RequestContext context) throws Exception {
        OlapDataSourceWrapper formObject = (OlapDataSourceWrapper)this.getFormObject(context);
        this.log("Saving the datasource back ");
        if (formObject.isStandAloneMode() && formObject.getType() != null) {
            ReportDataSource ds = formObject.getOlapDataSource();
            this.log("Saving DataSource name=" + ds.getName() + " datasource desc=" + ds.getDescription() + " in folder=" + ds.getParentFolder());
            if (ds.getName() != null) {
                this.repository.saveResource(null, (Resource)ds);
            }
        }
        return this.success();
    }

    public Object createFormObject(RequestContext context) {
        OlapDataSourceWrapper formObject = null;
        String resourceUri = context.getRequestParameters().get(DATASOURCEURI_PARAM);
        if (resourceUri != null && resourceUri.trim().length() != 0) {
            Resource resource = this.repository.getResource(null, resourceUri);
            if (resource == null) {
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{resourceUri});
            }
            this.log("Found resource with uri=" + resourceUri);
            formObject = new OlapDataSourceWrapper();
            formObject.setMode((byte)2);
            ReportDataSource dataSource = (ReportDataSource)resource;
            if ((class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JdbcOlapDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JdbcOlapDataSource = OlapDataSourceAction.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.JdbcOlapDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JdbcOlapDataSource).isAssignableFrom(dataSource.getClass())) {
                OlapDataSourceAction olapDataSourceAction = this;
                formObject.setType(olapDataSourceAction.constants.getJDBCDatasourceType());
            } else if ((class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JndiJdbcOlapDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JndiJdbcOlapDataSource = OlapDataSourceAction.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.JndiJdbcOlapDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JndiJdbcOlapDataSource).isAssignableFrom(dataSource.getClass())) {
                OlapDataSourceAction olapDataSourceAction = this;
                formObject.setType(olapDataSourceAction.constants.getJNDIDatasourceType());
            }
            formObject.setOlapDataSource(dataSource);
        }
        if (formObject == null) {
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (parentFolder == null || parentFolder.trim().length() == 0) {
                parentFolder = "/";
            }
            this.log("Datasource flow: Stand alone new mode");
            formObject = new OlapDataSourceWrapper();
            formObject.setMode((byte)1);
            OlapDataSourceAction olapDataSourceAction = this;
            formObject.setType(olapDataSourceAction.constants.getJNDIDatasourceType());
            OlapDataSourceAction olapDataSourceAction2 = this;
            formObject.setSource(olapDataSourceAction2.constants.getFieldChoiceLocal());
            JndiJdbcReportDataSource jndiSource = (JndiJdbcReportDataSource)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource = OlapDataSourceAction.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource);
            jndiSource.setParentFolder(parentFolder);
            jndiSource.setVersion(-1);
            formObject.setOlapDataSource((ReportDataSource)jndiSource);
        }
        formObject.setSelectedUri(resourceUri);
        return formObject;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public OlapConnectionService getOlapConnection() {
        return this.olapConnection;
    }

    public void setOlapConnection(OlapConnectionService olapConnection) {
        this.olapConnection = olapConnection;
    }

    private void log(String text) {
        this.log.debug((Object)text);
    }

    public static String getDATASOURCEURI_PARAM() {
        return DATASOURCEURI_PARAM;
    }

    public static String getFORM_OBJECT_KEY() {
        return FORM_OBJECT_KEY;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

