/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.ExportParameters;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.XlsExportParametersBean;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JExcelApiHyperlinkProducerFactory;
import com.jaspersoft.jasperserver.war.action.AbstractReportExporter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import jxl.write.biff.RowsExceededException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import org.springframework.webflow.execution.RequestContext;

public class ReportExcelExporter
extends AbstractReportExporter {
    private static final String DIALOG_NAME = "excelExportParams";
    private XlsExportParametersBean exportParameters;

    public XlsExportParametersBean getExportParameters() {
        return this.exportParameters;
    }

    public ExportParameters getExportParameters(RequestContext context) {
        return context.getFlowScope().get(DIALOG_NAME) == null ? this.exportParameters : (ExportParameters)context.getFlowScope().get(DIALOG_NAME);
    }

    public void setExportParameters(XlsExportParametersBean exportParameters) {
        this.exportParameters = exportParameters;
    }

    public void export(RequestContext context, ExecutionContext executionContext, String reportUnitURI, Map baseParameters) throws JRException, JSException {
        JExcelApiExporter exporter = new JExcelApiExporter();
        exporter.setParameters(baseParameters);
        XlsExportParametersBean exportParams = (XlsExportParametersBean)this.getExportParameters(context);
        if (exportParams.isOverrideReportHints()) {
            exporter.setParameter(JRExporterParameter.PARAMETERS_OVERRIDE_REPORT_HINTS, (Object)Boolean.TRUE);
        }
        if (exportParams.getOnePagePerSheet() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)exportParams.getOnePagePerSheet());
        }
        if (exportParams.getDetectCellType() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_DETECT_CELL_TYPE, (Object)exportParams.getDetectCellType());
        }
        if (exportParams.getRemoveEmptySpaceBetweenRows() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)exportParams.getRemoveEmptySpaceBetweenRows());
        }
        if (exportParams.getRemoveEmptySpaceBetweenColumns() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)exportParams.getRemoveEmptySpaceBetweenColumns());
        }
        if (exportParams.getWhitePageBackground() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)exportParams.getWhitePageBackground());
        }
        if (exportParams.getIgnoreGraphics() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IGNORE_GRAPHICS, (Object)exportParams.getIgnoreGraphics());
        }
        if (exportParams.getCollapseRowSpan() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_COLLAPSE_ROW_SPAN, (Object)exportParams.getCollapseRowSpan());
        }
        if (exportParams.getIgnoreCellBorder() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IGNORE_CELL_BORDER, (Object)exportParams.getIgnoreCellBorder());
        }
        if (exportParams.getFontSizeFixEnabled() != null) {
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)exportParams.getFontSizeFixEnabled());
        }
        if (exportParams.getMaximumRowsPerSheet() != null) {
            exporter.setParameter(JRXlsAbstractExporterParameter.MAXIMUM_ROWS_PER_SHEET, (Object)exportParams.getMaximumRowsPerSheet());
        }
        if (exportParams.getXlsFormatPatternsMap() != null && !exportParams.getXlsFormatPatternsMap().isEmpty()) {
            exporter.setParameter(JRXlsAbstractExporterParameter.FORMAT_PATTERNS_MAP, (Object)exportParams.getXlsFormatPatternsMap());
        }
        exporter.setParameter(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)JExcelApiHyperlinkProducerFactory.INSTANCE);
        exporter.setParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, (Object)Boolean.TRUE);
        try {
            exporter.exportReport();
        }
        catch (JRException e) {
            if (e.getCause() instanceof RowsExceededException) {
                throw new JSException("jsexception.too.many.data.rows");
            }
            throw e;
        }
    }

    protected String getContentType(RequestContext context) {
        return "application/xls";
    }

    protected void setAdditionalResponseHeaders(RequestContext context, HttpServletResponse response) {
        super.setAdditionalResponseHeaders(context, response);
        response.setHeader("Content-Disposition", "inline; filename=\"" + this.getFilename(context, "xls") + "\"");
    }
}

