/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.ExportParameters;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.PdfExportParametersBean;
import com.jaspersoft.jasperserver.war.action.AbstractReportExporter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRExporterParameter;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.webflow.execution.RequestContext;

public class ReportPdfExporter
extends AbstractReportExporter {
    private EngineService engine;
    private PdfExportParametersBean exportParameters;

    public void export(RequestContext context, ExecutionContext executionContext, String reportUnitURI, Map baseParameters) {
        Map localizedFontMap;
        String locale = LocaleContextHolder.getLocale().getLanguage();
        Map map = localizedFontMap = this.exportParameters.getLocalizedFontMap().get(locale) != null ? (Map)this.exportParameters.getLocalizedFontMap().get(locale) : (Map)this.exportParameters.getLocalizedFontMap().get(locale.substring(0, 2));
        if (localizedFontMap != null) {
            baseParameters.put(JRExporterParameter.FONT_MAP, localizedFontMap);
        }
        if (this.exportParameters.isOverrideReportHints()) {
            baseParameters.put(JRExporterParameter.PARAMETERS_OVERRIDE_REPORT_HINTS, Boolean.TRUE);
        }
        this.engine.exportToPdf(executionContext, reportUnitURI, baseParameters);
    }

    protected String getContentType(RequestContext context) {
        return "application/pdf";
    }

    protected void setAdditionalResponseHeaders(RequestContext context, HttpServletResponse response) {
        super.setAdditionalResponseHeaders(context, response);
        response.setHeader("Content-Disposition", "inline; filename=\"" + this.getFilename(context, "pdf") + "\"");
    }

    public EngineService getEngine() {
        return this.engine;
    }

    public void setEngine(EngineService engine) {
        this.engine = engine;
    }

    public ExportParameters getExportParameters(RequestContext context) {
        return null;
    }

    public PdfExportParametersBean getExportParameters() {
        return this.exportParameters;
    }

    public void setExportParameters(PdfExportParametersBean exportParameters) {
        this.exportParameters = exportParameters;
    }
}

