/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.util.List;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ReportSchedulingListAction
extends MultiAction {
    private String reportUnitURIAttrName;
    private String jobListAttrName;
    private String selectedJobsParamName;
    private String attributeOwnerURI;
    private ReportSchedulingService schedulingService;

    public ReportSchedulingService getSchedulingService() {
        return this.schedulingService;
    }

    public void setSchedulingService(ReportSchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }

    public String getJobListAttrName() {
        return this.jobListAttrName;
    }

    public void setJobListAttrName(String jobListAttrName) {
        this.jobListAttrName = jobListAttrName;
    }

    public String getReportUnitURIAttrName() {
        return this.reportUnitURIAttrName;
    }

    public void setReportUnitURIAttrName(String reportUnitURIAttrName) {
        this.reportUnitURIAttrName = reportUnitURIAttrName;
    }

    public String getSelectedJobsParamName() {
        return this.selectedJobsParamName;
    }

    public void setSelectedJobsParamName(String selectedJobsParamName) {
        this.selectedJobsParamName = selectedJobsParamName;
    }

    public Event listJobs(RequestContext context) {
        this.setRequestErrorMessage(context);
        List jobs = this.loadJobList(context);
        context.getRequestScope().put(this.getJobListAttrName(), (Object)jobs);
        context.getRequestScope().put(this.getAttributeOwnerURI(), (Object)this.getOwnerURI(context));
        return this.success();
    }

    protected String getOwnerURI(RequestContext context) {
        return context.getFlowScope().getRequiredString(this.getReportUnitURIAttrName());
    }

    protected List loadJobList(RequestContext context) {
        String reportUnitURI = context.getFlowScope().getString(this.getReportUnitURIAttrName());
        List jobs = this.schedulingService.getScheduledJobs(this.getExecutionContext(context), reportUnitURI);
        return jobs;
    }

    protected void setRequestErrorMessage(RequestContext context) {
        MutableAttributeMap flowScope = context.getFlowScope();
        if (flowScope.contains("errorMessage")) {
            String message = (String)flowScope.remove("errorMessage");
            Object args = flowScope.remove("errorArguments");
            MutableAttributeMap requestScope = context.getRequestScope();
            requestScope.put("errorMessage", (Object)message);
            requestScope.put("errorArguments", args);
        }
    }

    public Event deleteJobs(RequestContext context) {
        String[] selectedJobs = context.getRequestParameters().getArray(this.getSelectedJobsParamName());
        if (selectedJobs != null && selectedJobs.length > 0) {
            long[] jobIds = new long[selectedJobs.length];
            for (int i = 0; i < selectedJobs.length; ++i) {
                jobIds[i] = Long.parseLong(selectedJobs[i]);
            }
            this.schedulingService.removeScheduledJobs(this.getExecutionContext(context), jobIds);
        }
        return this.success();
    }

    protected ExecutionContext getExecutionContext(RequestContext context) {
        return JasperServerUtil.getExecutionContext(context);
    }

    public String getAttributeOwnerURI() {
        return this.attributeOwnerURI;
    }

    public void setAttributeOwnerURI(String attributeOwnerURI) {
        this.attributeOwnerURI = attributeOwnerURI;
    }
}

