/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action.tree;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import com.jaspersoft.jasperserver.war.model.TreeDataProviderFactory;
import com.jaspersoft.jasperserver.war.model.TreeHelper;
import com.jaspersoft.jasperserver.war.model.TreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class TreeAction
extends MultiAction {
    public static final String AJAX_REPORT_MODEL = "ajaxResponseModel";
    public static final String PROVIDER = "provider";
    public static final String URI = "uri";
    public static final String DEPTH = "depth";
    public static final String PREFETCH = "prefetch";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private TreeDataProviderFactory treeDataProviderFactory;

    public Event getNode(RequestContext context) {
        String providerId = context.getRequestParameters().get(PROVIDER);
        String uri = context.getRequestParameters().get(URI);
        String depth = context.getRequestParameters().get(DEPTH);
        String prefetchNodesList = context.getRequestParameters().get(PREFETCH);
        int d = 0;
        if (depth != null && depth.length() > 0) {
            try {
                d = Integer.parseInt(depth);
                if (d < 0) {
                    d = 0;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Invalid parameter : depth : " + depth), (Throwable)e);
            }
        }
        ArrayList<String> prefetchList = null;
        if (prefetchNodesList != null && prefetchNodesList.length() > 0) {
            String[] ss = prefetchNodesList.split(",");
            prefetchList = new ArrayList<String>();
            for (int i = 0; i < ss.length; ++i) {
                prefetchList.add(ss[i]);
            }
        }
        TreeDataProvider treeDataProvider = this.treeDataProviderFactory.getDataProvider(providerId);
        TreeNode treeNode = prefetchList == null ? treeDataProvider.getNode(this.exContext(context), uri, d) : TreeHelper.getSubtree(this.exContext(context), treeDataProvider, uri, prefetchList);
        String model = "";
        if (treeNode != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<div id='treeNodeText'>");
            sb.append(treeNode.toJSONString());
            sb.append("</div>");
            model = sb.toString();
        }
        context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)model);
        return this.success();
    }

    public Event getChildren(RequestContext context) {
        String providerId = context.getRequestParameters().get(PROVIDER);
        String uri = context.getRequestParameters().get(URI);
        TreeDataProvider treeDataProvider = this.treeDataProviderFactory.getDataProvider(providerId);
        TreeNode treeNode = treeDataProvider.getNode(this.exContext(context), uri, 1);
        String model = "";
        if (treeNode != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<div id='treeNodeText'>");
            sb.append('[');
            Iterator i = treeNode.getChildren().iterator();
            while (i.hasNext()) {
                TreeNode n = (TreeNode)i.next();
                sb.append(n.toJSONString());
                if (!i.hasNext()) continue;
                sb.append(',');
            }
            sb.append(']');
            sb.append("</div>");
            model = sb.toString();
        }
        context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)model);
        return this.success();
    }

    public TreeDataProviderFactory getTreeDataProviderFactory() {
        return this.treeDataProviderFactory;
    }

    public void setTreeDataProviderFactory(TreeDataProviderFactory treeDataProviderFactory) {
        this.treeDataProviderFactory = treeDataProviderFactory;
    }

    private ExecutionContext exContext(RequestContext rContext) {
        return JasperServerUtil.getExecutionContext(rContext);
    }
}

