/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.common;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.webflow.execution.RequestContext;

public class JasperServerUtil {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$war$common$JasperServerUtil == null ? (class$com$jaspersoft$jasperserver$war$common$JasperServerUtil = JasperServerUtil.class$("com.jaspersoft.jasperserver.war.common.JasperServerUtil")) : class$com$jaspersoft$jasperserver$war$common$JasperServerUtil));
    private static final Pattern PATTERN_NAME = Pattern.compile("(\\p{L}|\\p{N}|(\\_)|(\\.)|(\\-)|[;@])+");
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$common$JasperServerUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getJSDatabaseConnection() throws ClassNotFoundException, SQLException, NamingException {
        Connection con;
        block6: {
            boolean sqlExcpn = false;
            con = null;
            try {
                InitialContext cxt = new InitialContext();
                DataSource ds = (DataSource)cxt.lookup(JasperServerConstImpl.getJSDataSrc());
                Connection connection = con = ds.getConnection();
                return connection;
            }
            catch (Exception _ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)_ex, (Throwable)_ex);
                }
                sqlExcpn = true;
                return sqlExcpn;
            }
            finally {
                if (!sqlExcpn) break block6;
                Class.forName(JasperServerConstImpl.getJSConnector());
                con = DriverManager.getConnection(JasperServerConstImpl.getJSUrl(), JasperServerConstImpl.getJSDbUser(), JasperServerConstImpl.getJSDbPasswd());
                return con;
            }
        }
        return con;
    }

    public static JRHtmlExporter exportJRToHtml(JasperPrint jasperPrint, StringBuffer reportContent) throws JRException {
        JRHtmlExporter exporter = new JRHtmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STRING_BUFFER, (Object)reportContent);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.FALSE);
        exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)new Integer(0));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_HEADER, (Object)"");
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.BETWEEN_PAGES_HTML, (Object)"");
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_FOOTER, (Object)"");
        exporter.exportReport();
        return exporter;
    }

    public String parseFileName(String fullName) {
        int lastIndex = fullName.lastIndexOf(System.getProperty("file.separator"));
        fullName = fullName.substring(lastIndex + 1);
        return fullName;
    }

    public static boolean createNewReportUnit(RepositoryService repository, ReportUnit unit) throws Exception {
        repository.saveResource(null, (Resource)unit);
        return true;
    }

    public static Folder createNewFolder(RepositoryService repository, String folderName, String parentUri) throws Exception {
        FolderImpl folder = new FolderImpl();
        folder.setName(folderName);
        folder.setLabel(folderName);
        folder.setParentFolder(parentUri);
        repository.saveFolder(null, (Folder)folder);
        return folder;
    }

    public static boolean uploadToRepository(ReportUnit rpunit, String fileName) throws Exception {
        return true;
    }

    public static boolean regExValidateName(String inp) throws PatternSyntaxException {
        Matcher mat = PATTERN_NAME.matcher(inp.trim());
        return mat.matches();
    }

    public static boolean regExValidateLabel(String inp) throws PatternSyntaxException {
        return true;
    }

    public static boolean regExValidateEmail(String email) {
        try {
            new InternetAddress(email.trim(), true);
            return true;
        }
        catch (AddressException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Email address \"" + email + "\" not valid"));
            }
            return false;
        }
    }

    public static boolean regExValidateFolder(String folderName) throws PatternSyntaxException {
        return JasperServerUtil.regExValidateName(folderName.trim());
    }

    public static boolean regExValidateJndiServiceName(String jndiName) throws PatternSyntaxException {
        Pattern pat = Pattern.compile("([a-zA-Z]+(((\\:)|(\\/)){1}[a-zA-Z0-9]+)*)");
        Matcher mat = pat.matcher(jndiName.trim());
        return mat.matches();
    }

    public static boolean regExValidateDbDriver(String driverName) throws PatternSyntaxException {
        Pattern pat = Pattern.compile("([a-zA-Z]+((\\.){1}[a-zA-Z0-9]+)*)");
        Matcher mat = pat.matcher(driverName.trim());
        return mat.matches();
    }

    public static boolean regExValidateJdbcURL(String jdbcUrl) throws PatternSyntaxException {
        return true;
    }

    public static boolean regExValidateReportName(String reportName) throws PatternSyntaxException {
        Pattern pat = Pattern.compile("[a-zA-Z0-9]+((\\_){1}[a-zA-Z0-9]+)*");
        Matcher mat = pat.matcher(reportName.trim());
        return mat.matches();
    }

    public static ExecutionContext getExecutionContext(HttpServletRequest request) {
        return JasperServerUtil.getExecutionContext(RequestContextUtils.getLocale((HttpServletRequest)request));
    }

    public static ExecutionContext getExecutionContext() {
        return JasperServerUtil.getExecutionContext(LocaleContextHolder.getLocale());
    }

    public static ExecutionContext getExecutionContext(Locale locale) {
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setLocale(locale);
        return context;
    }

    public static ExecutionContext getExecutionContext(Locale locale, TimeZone timeZone) {
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setLocale(locale);
        context.setTimeZone(timeZone);
        return context;
    }

    public static ExecutionContext getExecutionContext(RequestContext context) {
        TimeZone timeZone = JasperServerUtil.getTimezone(context);
        return JasperServerUtil.getExecutionContext(LocaleContextHolder.getLocale(), timeZone);
    }

    public static TimeZone getTimezone(RequestContext context) {
        String timeZoneId = (String)context.getExternalContext().getSessionMap().get(JasperServerConstImpl.getUserTimezoneSessionAttr());
        return JasperServerUtil.getTimezone(timeZoneId);
    }

    protected static TimeZone getTimezone(String timeZoneId) {
        TimeZone timeZone = timeZoneId == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZoneId);
        return timeZone;
    }

    public static TimeZone getTimezone(HttpServletRequest request) {
        String timeZoneId = (String)request.getSession().getAttribute(JasperServerConstImpl.getUserTimezoneSessionAttr());
        return JasperServerUtil.getTimezone(timeZoneId);
    }

    public static void trimDTOFieldSpaces(Object object) {
        if (object instanceof User) {
            User user = (User)object;
            user.setUsername(user.getUsername().trim());
            user.setFullName(user.getFullName().trim());
            user.setEmailAddress(user.getEmailAddress().trim());
        } else if (object instanceof Role) {
            Role role = (Role)object;
            role.setRoleName(role.getRoleName().trim());
        }
    }

    public static DateFormat createCalendarDateFormat(MessageSource messages, Locale locale) {
        String pattern = messages.getMessage("date.format", null, locale);
        return new SimpleDateFormat(pattern);
    }

    public static DateFormat createCalendarDateFormat(MessageSource messages) {
        return JasperServerUtil.createCalendarDateFormat(messages, LocaleContextHolder.getLocale());
    }

    public static DateFormat createCalendarDateTimeFormat(MessageSource messages, Locale locale) {
        String pattern = messages.getMessage("datetime.format", null, locale);
        return new SimpleDateFormat(pattern);
    }

    public static DateFormat createCalendarDateTimeFormat(MessageSource messages) {
        return JasperServerUtil.createCalendarDateTimeFormat(messages, LocaleContextHolder.getLocale());
    }

    public static String formatDate(MessageSource messages, Date date, TimeZone timeZone) {
        DateFormat format = JasperServerUtil.createCalendarDateTimeFormat(messages);
        format.setTimeZone(timeZone);
        return format.format(date);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

