/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.control;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractView;

public class ContentRepositoryFileView
extends AbstractView {
    public static final String REPOSITORY_PATH = "repositoryPath";
    RepositoryService repository;

    public ContentRepositoryFileView(RepositoryService repository) {
        this.repository = repository;
    }

    protected void renderMergedOutputModel(Map map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int start;
        String pathinfo = request.getPathInfo();
        String repoPath = pathinfo.substring(start = pathinfo.indexOf(47, 1), pathinfo.length());
        if (repoPath == null || repoPath.length() == 0) {
            return;
        }
        ServletOutputStream out = response.getOutputStream();
        ContentResource file = (ContentResource)this.repository.getResource(null, repoPath);
        String fileType = file.getFileType();
        if (fileType == null) {
            throw new JSException("jsexception.undefined.file.type");
        }
        FileResourceData fileData = this.repository.getContentResourceData(null, repoPath);
        if (fileType.equals("pdf")) {
            response.setContentType("application/pdf");
        } else if (fileType.equals("xls")) {
            response.setContentType("application/xls");
            response.setHeader("Content-Disposition", "inline; filename=\"file.xls\"");
        } else if (fileType.equals("rtf")) {
            response.setContentType("application/rtf");
        } else if (fileType.equals("csv")) {
            response.setContentType("text/csv");
        }
        if (fileData.getData() == null) {
            response.setContentLength(0);
        } else {
            response.setContentLength(fileData.getData().length);
            InputStream in = fileData.getDataStream();
            byte[] b = new byte[1024];
            while (in.read(b) != -1) {
                out.write(b);
            }
        }
        out.flush();
    }
}

