/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.model.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositoryServiceSecurityChecker;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.model.JSONObject;
import com.jaspersoft.jasperserver.war.model.TreeDataFilter;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import com.jaspersoft.jasperserver.war.model.TreeNode;
import com.jaspersoft.jasperserver.war.model.impl.TreeNodeImpl;
import java.util.Iterator;
import java.util.List;

public class RepositoryTreeDataProviderImpl
implements TreeDataProvider {
    private RepositoryService repositoryService;
    private RepositoryServiceSecurityChecker repositoryServiceSecurityChecker;
    private TreeDataFilter filter;

    public List getChildren(ExecutionContext executionContext, String parentUri, int depth) {
        TreeNode n = this.getNode(executionContext, parentUri, depth + 1);
        if (n != null) {
            return n.getChildren();
        }
        return null;
    }

    public TreeNode getNode(ExecutionContext executionContext, String uri, int depth) {
        Resource resource = this.repositoryService.getResource(executionContext, uri);
        if (resource != null) {
            return this.createNode(resource);
        }
        Folder folder = this.repositoryService.getFolder(executionContext, uri);
        if (folder != null) {
            TreeNode node = this.createNode((Resource)folder);
            if (depth > 0) {
                this.processFolder(node, depth - 1);
            }
            return node;
        }
        return null;
    }

    private TreeNode createNode(Resource resource) {
        Permissions extraProperty = new Permissions();
        extraProperty.isWritable = this.repositoryServiceSecurityChecker.isEditable(resource);
        return new TreeNodeImpl(this, resource.getName(), resource.getLabel(), resource.getResourceType(), resource.getURIString(), extraProperty);
    }

    private void processFolder(TreeNode folder, int depth) {
        TreeNode n;
        Iterator iter;
        String folderURI = folder.getUriString();
        FilterCriteria criteria = FilterCriteria.createFilter();
        criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderURI));
        List folders = this.repositoryService.getSubFolders(null, folderURI);
        List resources = this.repositoryService.loadResourcesList(null, criteria);
        if (folders != null) {
            iter = folders.iterator();
            while (iter.hasNext()) {
                Folder f = (Folder)iter.next();
                n = this.createNode((Resource)f);
                if (this.filter != null && !this.filter.filter(n)) continue;
                folder.getChildren().add(n);
                if (depth <= 0) continue;
                this.processFolder(n, depth - 1);
            }
        }
        if (resources != null) {
            iter = resources.iterator();
            while (iter.hasNext()) {
                Resource r = (Resource)iter.next();
                n = this.createNode(r);
                if (this.filter != null && !this.filter.filter(n)) continue;
                folder.getChildren().add(n);
            }
        }
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public RepositoryServiceSecurityChecker getRepositoryServiceSecurityChecker() {
        return this.repositoryServiceSecurityChecker;
    }

    public void setRepositoryServiceSecurityChecker(RepositoryServiceSecurityChecker repositoryServiceSecurityChecker) {
        this.repositoryServiceSecurityChecker = repositoryServiceSecurityChecker;
    }

    public TreeDataFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TreeDataFilter filter) {
        this.filter = filter;
    }

    private static class Permissions
    implements JSONObject {
        public boolean isWritable = true;

        private Permissions() {
        }

        public String toJSONString() {
            return this.isWritable ? "{\"isWritable\":true}" : "{\"isWritable\":false}";
        }
    }
}

