/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.model.impl;

import com.jaspersoft.jasperserver.war.model.JSONObject;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import com.jaspersoft.jasperserver.war.model.TreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TreeNodeImpl
implements TreeNode {
    protected String id;
    protected String label;
    protected String type;
    protected String uri;
    protected JSONObject extraProperty;
    protected List children = new ArrayList();
    protected TreeDataProvider dataProvider;

    public TreeNodeImpl(TreeDataProvider dataProvider, String id, String label, String type, String uri) {
        this.dataProvider = dataProvider;
        this.id = id;
        this.label = label;
        this.type = type;
        this.uri = uri;
    }

    public TreeNodeImpl(TreeDataProvider dataProvider, String id, String label, String type, String uri, JSONObject extraProperty) {
        this(dataProvider, id, label, type, uri);
        this.extraProperty = extraProperty;
    }

    public List getChildren() {
        return this.children;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getType() {
        return this.type;
    }

    public String getUriString() {
        return this.uri;
    }

    public JSONObject getExtraProperty() {
        return this.extraProperty;
    }

    public void setExtraProperty(JSONObject extraProperty) {
        this.extraProperty = extraProperty;
    }

    public String toJSONString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{\"id\":\"").append(this.id).append("\",").append("\"label\":\"").append(this.escape(this.label)).append("\",").append("\"type\":\"").append(this.type).append("\",").append("\"uri\":\"").append(this.uri).append("\"");
        if (this.extraProperty != null) {
            sb.append(",\"extra\":").append(this.extraProperty.toJSONString());
        }
        if (!this.children.isEmpty()) {
            sb.append(",\"children\":[");
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                TreeNode child = (TreeNode)iter.next();
                sb.append(child.toJSONString());
                if (!iter.hasNext()) continue;
                sb.append(',');
            }
            sb.append(']');
        }
        sb.append('}');
        return sb.toString();
    }

    protected String escape(String str) {
        return str == null ? null : str.replace("\"", "\\\"");
    }
}

