/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.tags;

import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;

public class CalendarInputTag
extends TagSupport {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$war$tags$CalendarInputTag == null ? (class$com$jaspersoft$jasperserver$war$tags$CalendarInputTag = CalendarInputTag.class$("com.jaspersoft.jasperserver.war.tags.CalendarInputTag")) : class$com$jaspersoft$jasperserver$war$tags$CalendarInputTag));
    public static final String DEFAULT_DATE_FORMAT_MESSAGE = "calendar.date.format";
    public static final String DEFAULT_DATETIME_FORMAT_MESSAGE = "calendar.datetime.format";
    public static final String DEFAULT_IMAGE = "/images/cal.gif";
    private boolean time = true;
    private String formatPattern;
    private String name;
    private String value;
    private String timezoneOffset;
    private boolean readOnly = false;
    private String onchange;
    private String imageSrc;
    private String imageTipMessage;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$tags$CalendarInputTag;

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        WebApplicationContext applicationContext = RequestContextUtils.getWebApplicationContext((ServletRequest)request);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        try {
            JspWriter out = this.pageContext.getOut();
            out.write("\n<input type=\"text\" name=\"" + this.name + "\" id=\"" + this.name + "\" class=\"fnormal\" value=\"" + this.value + "\"");
            if (this.onchange != null && this.onchange.length() > 0) {
                out.write(" onchange=\"" + this.onchange + "\"");
            }
            if (this.isReadOnly()) {
                out.write(" disabled=\"disabled\"");
            }
            out.write("/>\n");
            if (!this.isReadOnly()) {
                out.write("<img style=\"vertical-align:middle;\" src=\"" + this.getImageSource(request) + "\" id=\"" + this.name + "Img\" border=\"0\"");
                String imageTooltip = this.getImageTooltip(applicationContext, locale);
                if (imageTooltip != null) {
                    out.write(" alt=\"" + imageTooltip + "\"");
                }
                out.write("/>\n");
                out.write("<script>\n");
                out.write("\tCalendar.setup({\n");
                out.write("\t\tinputField : \"" + this.name + "\",\n");
                out.write("\t\tifFormat : \"" + this.getPattern(applicationContext, locale) + "\", \n");
                out.write("\t\tbutton : \"" + this.name + "Img\", \n");
                out.write("\t\tshowsTime : " + this.time + ", \n");
                out.write("\t\ttzOffset : " + this.getTimezoneOffset(request) + "\n");
                out.write("\t});\n");
                out.write("</script>");
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    protected String getPattern(WebApplicationContext applicationContext, Locale locale) {
        String pattern = this.formatPattern;
        if (pattern == null) {
            String message = this.isTime() ? DEFAULT_DATETIME_FORMAT_MESSAGE : DEFAULT_DATE_FORMAT_MESSAGE;
            pattern = applicationContext.getMessage(message, null, locale);
        }
        return pattern;
    }

    protected String getImageSource(HttpServletRequest request) {
        String imageSource = this.imageSrc;
        if (imageSource == null) {
            imageSource = request.getContextPath() + DEFAULT_IMAGE;
        }
        return imageSource;
    }

    protected String getImageTooltip(WebApplicationContext applicationContext, Locale locale) {
        String message = null;
        if (this.imageTipMessage != null) {
            message = applicationContext.getMessage(this.imageTipMessage, null, locale);
        }
        return message;
    }

    protected String getTimezoneOffset(HttpServletRequest request) {
        String tzOffset = this.timezoneOffset;
        if (tzOffset == null) {
            TimeZone timezone = JasperServerUtil.getTimezone(request);
            int offset = timezone.getOffset(System.currentTimeMillis());
            tzOffset = Integer.toString(offset);
        }
        return tzOffset;
    }

    public void release() {
        this.time = true;
        this.formatPattern = null;
        this.name = null;
        this.value = null;
        this.readOnly = false;
        this.onchange = null;
        this.imageSrc = null;
        this.imageTipMessage = null;
        super.release();
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    public void setFormatPattern(String formatPattern) {
        this.formatPattern = formatPattern;
    }

    public String getImageSrc() {
        return this.imageSrc;
    }

    public void setImageSrc(String imageSrc) {
        this.imageSrc = imageSrc;
    }

    public String getImageTipMessage() {
        return this.imageTipMessage;
    }

    public void setImageTipMessage(String imageTipMessage) {
        this.imageTipMessage = imageTipMessage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOnchange() {
        return this.onchange;
    }

    public void setOnchange(String onChange) {
        this.onchange = onChange;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isTime() {
        return this.time;
    }

    public void setTime(boolean time) {
        this.time = time;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getTimezoneOffset() {
        return this.timezoneOffset;
    }

    public void setTimezoneOffset(String timezoneOffset) {
        this.timezoneOffset = timezoneOffset;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

