/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.util;

import com.jaspersoft.jasperserver.api.common.util.CharacterEncodingProvider;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CharacterEncodingFilter
implements Filter {
    private String encodingRequestAttrName;
    private CharacterEncodingProvider encodingProvider;

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.hasEncoding(request)) {
            chain.doFilter(request, response);
        } else {
            String encoding = this.getEncoding();
            this.setEncoding(request, encoding);
            if (request.getCharacterEncoding() == null) {
                request.setCharacterEncoding(encoding);
            }
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            CharsetEncodingResponseWrapper responseWrapper = new CharsetEncodingResponseWrapper(httpServletResponse, encoding);
            chain.doFilter(request, (ServletResponse)responseWrapper);
        }
    }

    protected void setEncoding(ServletRequest request, String encoding) {
        request.setAttribute(this.getEncodingRequestAttrName(), (Object)encoding);
    }

    protected boolean hasEncoding(ServletRequest request) {
        return request.getAttribute(this.getEncodingRequestAttrName()) != null;
    }

    protected String getEncoding() {
        return this.getEncodingProvider().getCharacterEncoding();
    }

    public CharacterEncodingProvider getEncodingProvider() {
        return this.encodingProvider;
    }

    public void setEncodingProvider(CharacterEncodingProvider encodingProvider) {
        this.encodingProvider = encodingProvider;
    }

    public String getEncodingRequestAttrName() {
        return this.encodingRequestAttrName;
    }

    public void setEncodingRequestAttrName(String filteredReqAttrName) {
        this.encodingRequestAttrName = filteredReqAttrName;
    }

    protected static class CharsetEncodingResponseWrapper
    extends HttpServletResponseWrapper {
        private boolean encodingSpecified = false;
        private final String encoding;

        public CharsetEncodingResponseWrapper(HttpServletResponse response, String encoding) {
            super(response);
            this.encoding = encoding;
        }

        public void setContentType(String type) {
            String encType = type;
            if (!this.encodingSpecified) {
                String lowerType = type.toLowerCase();
                if (lowerType.indexOf("charset") < 0) {
                    if (lowerType.startsWith("text/html")) {
                        encType = type + "; charset=" + this.encoding;
                    }
                } else {
                    this.encodingSpecified = true;
                }
            }
            super.setContentType(encType);
        }
    }
}

