/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.util;

import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class ValidationErrorsUtils {
    private static final ValidationErrorsUtils instance = new ValidationErrorsUtils();

    public static ValidationErrorsUtils instance() {
        return instance;
    }

    protected ValidationErrorsUtils() {
    }

    public void setErrors(Errors errors, ValidationErrors validationErrors, String[] fieldPrefixes) {
        HashSet<String> bindErrorFields = new HashSet<String>();
        Iterator it = errors.getAllErrors().iterator();
        while (it.hasNext()) {
            ObjectError error = (ObjectError)it.next();
            if (!(error instanceof FieldError)) continue;
            bindErrorFields.add(((FieldError)error).getField());
        }
        if (validationErrors.isError()) {
            List errorList = validationErrors.getErrors();
            Iterator it2 = errorList.iterator();
            while (it2.hasNext()) {
                ValidationError error = (ValidationError)it2.next();
                if (!this.matches(error, fieldPrefixes)) continue;
                this.setError(errors, bindErrorFields, error);
            }
        }
    }

    protected boolean matches(ValidationError error, String[] fieldPrefixes) {
        String prefix;
        String field = error.getField();
        if (fieldPrefixes == null || field == null) {
            return true;
        }
        boolean match = false;
        for (int i = 0; !match && i < fieldPrefixes.length; match |= field.startsWith(prefix), ++i) {
            prefix = fieldPrefixes[i];
        }
        return match;
    }

    protected void setError(Errors errors, Set bindErrorFields, ValidationError error) {
        if (error.getField() == null) {
            errors.reject(error.getErrorCode(), error.getErrorArguments(), error.getDefaultMessage());
        } else if (!bindErrorFields.contains(error.getField())) {
            errors.rejectValue(error.getField(), error.getErrorCode(), error.getErrorArguments(), error.getDefaultMessage());
        }
    }
}

