/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValuesItem;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.war.common.JasperServerConst;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.ListOfValuesDTO;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class ListOfValuesValidator
implements Validator {
    private RepositoryService repository;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$ListOfValuesDTO;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public boolean supports(Class klass) {
        return (class$com$jaspersoft$jasperserver$war$dto$ListOfValuesDTO == null ? (class$com$jaspersoft$jasperserver$war$dto$ListOfValuesDTO = ListOfValuesValidator.class$("com.jaspersoft.jasperserver.war.dto.ListOfValuesDTO")) : class$com$jaspersoft$jasperserver$war$dto$ListOfValuesDTO).isAssignableFrom(klass);
    }

    public void validate(Object object, Errors errors) {
    }

    public void validateResourceData(ListOfValuesDTO listOfValuesDTO, Errors errors) {
        ListOfValues listOfValues = listOfValuesDTO.getListOfValues();
        if (listOfValues.getName() == null || this.size(listOfValues.getName()) == 0) {
            errors.rejectValue("listOfValues.name", "ListOfValuesValidator.error.not.empty");
        } else {
            if (listOfValues.getName().length() > 30) {
                errors.rejectValue("listOfValues.name", "ListOfValuesValidator.error.too.long", new Object[]{JasperServerConst.MAX_LENGTH_NAME_W}, null);
            } else if (!JasperServerUtil.regExValidateName(listOfValues.getName())) {
                errors.rejectValue("listOfValues.name", "ListOfValuesValidator.error.invalid.chars");
            }
            if (listOfValuesDTO.isAloneNewMode() && this.repository.repositoryPathExists(null, listOfValues.getURIString())) {
                errors.rejectValue("listOfValues.name", "ListOfValuesValidator.error.duplicate");
            }
        }
        if (listOfValues.getLabel() == null || this.size(listOfValues.getLabel()) == 0) {
            errors.rejectValue("listOfValues.label", "ListOfValuesValidator.error.not.empty");
        } else if (listOfValues.getLabel().length() > 30) {
            errors.rejectValue("listOfValues.label", "ListOfValuesValidator.error.too.long", new Object[]{JasperServerConst.MAX_LENGTH_LABEL_W}, null);
        } else if (!JasperServerUtil.regExValidateLabel(listOfValues.getLabel())) {
            errors.rejectValue("listOfValues.label", "ListOfValuesValidator.error.invalid.chars");
        }
        if (listOfValues.getDescription() != null && this.size(listOfValues.getDescription()) > 100) {
            errors.rejectValue("listOfValues.description", "ListOfValuesValidator.error.too.long", new Object[]{JasperServerConst.MAX_LENGTH_DESC_W}, null);
        }
    }

    public void validateAddValue(ListOfValuesDTO listOfValuesDTO, Errors errors) {
        String newLabel = listOfValuesDTO.getNewLabel();
        if (newLabel == null || this.size(newLabel) == 0) {
            errors.rejectValue("newLabel", "ListOfValuesValidator.error.not.empty");
        } else if (newLabel.length() > 30) {
            errors.rejectValue("newLabel", "ListOfValuesValidator.error.too.long", new Object[]{JasperServerConst.MAX_LENGTH_LABEL_W}, null);
        } else if (!JasperServerUtil.regExValidateLabel(newLabel)) {
            errors.rejectValue("newLabel", "ListOfValuesValidator.error.invalid.chars");
        }
        if (listOfValuesDTO.getNewValue() == null || this.size(listOfValuesDTO.getNewValue()) == 0) {
            errors.rejectValue("newValue", "ListOfValuesValidator.error.not.empty");
        } else if (listOfValuesDTO.getNewValue().length() > 30) {
            errors.rejectValue("newValue", "ListOfValuesValidator.error.too.long", new Object[]{JasperServerConst.MAX_LENGTH_LABEL_W}, null);
        }
    }

    public void validateLovSave(ListOfValuesDTO listOfValuesDTO, Errors errors) {
        ListOfValuesItem[] values = listOfValuesDTO.getListOfValues().getValues();
        if (values == null || values.length == 0) {
            errors.rejectValue("newLabel", "ListOfValuesValidator.error.no.data");
        }
    }

    private int size(String text) {
        return text.trim().length();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

