/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.MondrianXmlaSourceWrapper;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class MondrianXmlaSourceValidator
implements Validator {
    private RepositoryService repository;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$MondrianXmlaSourceWrapper;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public boolean supports(Class klass) {
        return (class$com$jaspersoft$jasperserver$war$dto$MondrianXmlaSourceWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$MondrianXmlaSourceWrapper = MondrianXmlaSourceValidator.class$("com.jaspersoft.jasperserver.war.dto.MondrianXmlaSourceWrapper")) : class$com$jaspersoft$jasperserver$war$dto$MondrianXmlaSourceWrapper).isAssignableFrom(klass);
    }

    public void validate(Object o, Errors errors) {
        MondrianXmlaSourceWrapper details = (MondrianXmlaSourceWrapper)o;
        this.validateNameLabelDesc(details, errors);
    }

    public void validateNameLabelDesc(MondrianXmlaSourceWrapper wrapper, Errors errors) {
        MondrianXMLADefinition mondrianXmlaDefinition = wrapper.getMondrianXmlaDefinition();
        if (mondrianXmlaDefinition.getName() == null || mondrianXmlaDefinition.getName().trim().length() == 0) {
            errors.rejectValue("mondrianXmlaDefinition.name", "MondrianXmlaSourceValidator.error.not.empty");
        } else {
            if (!JasperServerUtil.regExValidateName(mondrianXmlaDefinition.getName())) {
                errors.rejectValue("mondrianXmlaDefinition.name", "MondrianXmlaSourceValidator.error.invalid.chars");
            }
            if (mondrianXmlaDefinition.getName().length() > 100) {
                errors.rejectValue("mondrianXmlaDefinition.name", "MondrianXmlaSourceValidator.error.too.long");
            }
            if (wrapper.isAloneNewMode() && this.repository.repositoryPathExists(null, mondrianXmlaDefinition.getURIString())) {
                errors.rejectValue("mondrianXmlaDefinition.name", "MondrianXmlaSourceValidator.error.duplicate");
            }
        }
        if (mondrianXmlaDefinition.getLabel() == null || mondrianXmlaDefinition.getLabel().trim().length() == 0) {
            errors.rejectValue("mondrianXmlaDefinition.label", "MondrianXmlaSourceValidator.error.not.empty");
        } else {
            if (!JasperServerUtil.regExValidateLabel(mondrianXmlaDefinition.getLabel())) {
                errors.rejectValue("mondrianXmlaDefinition.label", "MondrianXmlaSourceValidator.error.invalid.chars");
            }
            if (mondrianXmlaDefinition.getLabel().length() > 100) {
                errors.rejectValue("mondrianXmlaDefinition.label", "MondrianXmlaSourceValidator.error.too.long");
            }
        }
        if (mondrianXmlaDefinition.getDescription() != null && mondrianXmlaDefinition.getDescription().length() > 100) {
            errors.rejectValue("mondrianXmlaDefinition.description", "MondrianXmlaSourceValidator.error.too.long");
        }
        if (mondrianXmlaDefinition.getCatalog() == null || mondrianXmlaDefinition.getCatalog().trim().length() == 0) {
            errors.rejectValue("mondrianXmlaDefinition.catalog", "MondrianXmlaSourceValidator.error.not.empty");
        } else {
            if (!JasperServerUtil.regExValidateName(mondrianXmlaDefinition.getCatalog())) {
                errors.rejectValue("mondrianXmlaDefinition.catalog", "MondrianXmlaSourceValidator.error.invalid.chars");
            }
            if (!this.validateUniqueCatalog(mondrianXmlaDefinition.getCatalog(), mondrianXmlaDefinition.getURIString())) {
                errors.rejectValue("mondrianXmlaDefinition.catalog", "MondrianXmlaSourceValidator.error.catalog.exists");
            }
        }
    }

    private boolean validateUniqueCatalog(String catalog, String uri) {
        RepositoryService rep = this.getRepository();
        FilterCriteria criteria = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition = MondrianXmlaSourceValidator.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition));
        ResourceLookup[] lookups = rep.findResource(null, criteria);
        catalog = catalog.toLowerCase();
        for (int i = 0; i < lookups.length; ++i) {
            Resource res = rep.getResource(null, lookups[i].getURIString());
            MondrianXMLADefinition def = (MondrianXMLADefinition)res;
            if (!def.getCatalog().toLowerCase().equals(catalog) || def.getURIString().equals(uri)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

