/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.LogEvent;
import com.jaspersoft.jasperserver.api.common.domain.impl.LogEventImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.LoggingService;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateLoggingService
extends HibernateDaoSupport
implements LoggingService {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$engine$common$service$impl$HibernateLoggingService == null ? (class$com$jaspersoft$jasperserver$api$engine$common$service$impl$HibernateLoggingService = HibernateLoggingService.class$("com.jaspersoft.jasperserver.api.engine.common.service.impl.HibernateLoggingService")) : class$com$jaspersoft$jasperserver$api$engine$common$service$impl$HibernateLoggingService));
    private static final long EVENT_ID_NEW = 0L;
    private SecurityContextProvider securityContextProvider;
    private int maximumAge;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$engine$common$service$impl$HibernateLoggingService;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$common$domain$impl$LogEventImpl;

    public SecurityContextProvider getSecurityContextProvider() {
        return this.securityContextProvider;
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    public int getMaximumAge() {
        return this.maximumAge;
    }

    public void setMaximumAge(int days) {
        this.maximumAge = days;
    }

    public LogEvent instantiateLogEvent() {
        return this.createLogEvent();
    }

    protected LogEvent createLogEvent() {
        return new LogEventImpl();
    }

    public void log(LogEvent event) {
        this.prepareForSave(event);
        this.getHibernateTemplate().save((Object)event);
    }

    public void update(LogEvent event) {
        this.getHibernateTemplate().saveOrUpdate((Object)event);
    }

    protected void prepareForSave(LogEvent event) {
        event.setId(0L);
        if (event.getOccurrenceDate() == null) {
            event.setOccurrenceDate(new Date());
        }
        event.setUsername(this.securityContextProvider.getContextUsername());
    }

    public void purge() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -this.getMaximumAge());
        Date last = cal.getTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Purging log events older than " + last));
        }
        this.getHibernateTemplate().bulkUpdate("delete LogEventImpl e where e.occurrenceDate < ?", (Object)last);
    }

    public void delete(ExecutionContext context, long[] eventIds) {
        for (int i = 0; i < eventIds.length; ++i) {
            LogEvent event = this.getLogEvent(context, eventIds[i]);
            this.getHibernateTemplate().delete((Object)event);
        }
    }

    public List getUserEvents(ExecutionContext context) {
        String username = this.securityContextProvider.getContextUsername();
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)(class$com$jaspersoft$jasperserver$api$common$domain$impl$LogEventImpl == null ? (class$com$jaspersoft$jasperserver$api$common$domain$impl$LogEventImpl = HibernateLoggingService.class$("com.jaspersoft.jasperserver.api.common.domain.impl.LogEventImpl")) : class$com$jaspersoft$jasperserver$api$common$domain$impl$LogEventImpl));
        if (username != null) {
            criteria.add((Criterion)Restrictions.eq((String)"username", (Object)username));
        }
        criteria.addOrder(Order.desc((String)"occurrenceDate"));
        List events = this.getHibernateTemplate().findByCriteria(criteria);
        return events;
    }

    public List getUnreadEvents(ExecutionContext context) {
        String username = this.securityContextProvider.getContextUsername();
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)(class$com$jaspersoft$jasperserver$api$common$domain$impl$LogEventImpl == null ? (class$com$jaspersoft$jasperserver$api$common$domain$impl$LogEventImpl = HibernateLoggingService.class$("com.jaspersoft.jasperserver.api.common.domain.impl.LogEventImpl")) : class$com$jaspersoft$jasperserver$api$common$domain$impl$LogEventImpl));
        criteria.add((Criterion)Restrictions.eq((String)"state", (Object)new Byte(1)));
        if (username != null) {
            criteria.add((Criterion)Restrictions.eq((String)"username", (Object)username));
        }
        criteria.addOrder(Order.desc((String)"occurrenceDate"));
        List events = this.getHibernateTemplate().findByCriteria(criteria);
        return events;
    }

    public LogEvent getLogEvent(ExecutionContext context, long id) {
        LogEvent event = (LogEvent)this.getHibernateTemplate().get(class$com$jaspersoft$jasperserver$api$common$domain$impl$LogEventImpl == null ? (class$com$jaspersoft$jasperserver$api$common$domain$impl$LogEventImpl = HibernateLoggingService.class$("com.jaspersoft.jasperserver.api.common.domain.impl.LogEventImpl")) : class$com$jaspersoft$jasperserver$api$common$domain$impl$LogEventImpl, (Serializable)new Long(id));
        if (event == null) {
            log.debug((Object)("Log event with id " + id + " not found"));
        }
        return event;
    }

    public int getUserEventsCount(ExecutionContext context) {
        String username = this.securityContextProvider.getContextUsername();
        List result = this.getHibernateTemplate().find("select count(*) from LogEventImpl where state=?", (Object)new Byte(1));
        if (result != null) {
            Integer size = (Integer)result.get(0);
            return size;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

