/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationDetail;
import com.jaspersoft.jasperserver.api.common.domain.ValidationResult;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationDetailImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationResultImpl;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.common.domain.Result;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.ReportExecuter;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequestBase;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CompiledReportProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.DataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.DefaultProtectionDomainProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JRQueryExecuterAdapter;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JarsClassLoader;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.ProtectionDomainProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryCacheMap;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryResourceClassLoader;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryResourceKey;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryUtil;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.ResourceCollector;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.repo.RepositoryURLHandlerFactory;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCache;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCacheableItem;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.fill.JRParameterDefaultValuesEvaluator;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EngineServiceImpl
implements EngineService,
ReportExecuter,
CompiledReportProvider {
    protected static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$engine$jasperreports$service$impl$EngineServiceImpl == null ? (class$com$jaspersoft$jasperserver$api$engine$jasperreports$service$impl$EngineServiceImpl = EngineServiceImpl.class$("com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.EngineServiceImpl")) : class$com$jaspersoft$jasperserver$api$engine$jasperreports$service$impl$EngineServiceImpl));
    private DataSourceServiceFactory dataSourceServiceFactories;
    protected RepositoryService repository;
    private SecurityContextProvider securityContextProvider;
    private String loggedInUserReportParameterName;
    private ProtectionDomainProvider reportJarsProtectionDomainProvider = new DefaultProtectionDomainProvider();
    private RepositoryCacheMap tempJarFiles;
    private RepositoryCache compiledReportsCache;
    private final ReferenceMap jarsClassLoaderCache = new ReferenceMap(2, 1);
    private final ReferenceMap resourcesClassLoaderCache = new ReferenceMap(2, 1);
    private final RepositoryCacheableItem cacheableCompiledReports = new CacheableCompiledReports();
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$engine$jasperreports$service$impl$EngineServiceImpl;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportDataSource;

    public RepositoryService getRepositoryService() {
        return this.repository;
    }

    public void setRepositoryService(RepositoryService repository) {
        this.repository = repository;
        this.createJarFilesCache();
    }

    public RepositoryCache getCompiledReportsCache() {
        return this.compiledReportsCache;
    }

    public void setCompiledReportsCache(RepositoryCache compiledReportsCache) {
        this.compiledReportsCache = compiledReportsCache;
    }

    protected void createJarFilesCache() {
        this.tempJarFiles = new RepositoryCacheMap(this.repository, new TempJarFileCacheObject());
    }

    protected InputStream getFileResourceDataStream(ExecutionContext context, FileResource fileResource) {
        InputStream data;
        if (fileResource.hasData()) {
            data = fileResource.getDataStream();
        } else {
            FileResourceData resourceData = this.repository.getResourceData(context, fileResource.getURIString());
            data = resourceData.getDataStream();
        }
        return data;
    }

    protected RepositoryCacheMap.CacheObject getCacheJarFile(ExecutionContext context, FileResource jar, boolean cache) {
        return this.tempJarFiles.cache(context, jar, cache);
    }

    protected byte[] getFileResourceData(ExecutionContext context, FileResource fileResource) {
        byte[] data;
        if (fileResource.hasData()) {
            data = fileResource.getData();
        } else {
            FileResourceData resourceData = this.repository.getResourceData(context, fileResource.getURIString());
            data = resourceData.getData();
        }
        return data;
    }

    public DataSourceServiceFactory getDataSourceServiceFactories() {
        return this.dataSourceServiceFactories;
    }

    public void setDataSourceServiceFactories(DataSourceServiceFactory dataSourceServiceFactories) {
        this.dataSourceServiceFactories = dataSourceServiceFactories;
    }

    public Result execute(ExecutionContext context, Request request) {
        ReportUnitRequestBase reportUnitRequest = (ReportUnitRequestBase)request;
        return reportUnitRequest.execute(context, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToPdf(ExecutionContext context, String reportUnitURI, Map exportParameters) {
        ReportUnit reportUnit = (ReportUnit)this.getRepositoryResource(context, reportUnitURI);
        this.setThreadRepositoryContext(context, null, reportUnitURI, false);
        try {
            OrigContextClassLoader origContext = this.setContextClassLoader(context, reportUnit, false);
            try {
                exportParameters.put(JRExporterParameter.URL_HANDLER_FACTORY, RepositoryURLHandlerFactory.getInstance());
                JRPdfExporter exporter = new JRPdfExporter();
                exporter.setParameters(exportParameters);
                exporter.exportReport();
            }
            finally {
                this.revert(origContext);
            }
        }
        catch (JRException e) {
            log.error((Object)"Error while exporting report to PDF", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        finally {
            RepositoryUtil.clearThreadRepositoryContext();
        }
    }

    protected void setThreadRepositoryContext(ExecutionContext context, ReportUnit reportUnit, String reportUnitURI, boolean inMemoryUnit) {
        RepositoryContext repositoryContext = new RepositoryContext();
        repositoryContext.setRepository(this.repository);
        repositoryContext.setContextResourceURI(reportUnitURI);
        if (inMemoryUnit) {
            repositoryContext.setReportUnit(reportUnit);
        }
        repositoryContext.setExecutionContext(context);
        repositoryContext.setCompiledReportProvider(this);
        RepositoryUtil.setThreadRepositoryContext(repositoryContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReportUnitResult fillReport(ExecutionContext context, ReportUnit reportUnit, Map parameters, boolean inMemoryUnit) {
        this.setThreadRepositoryContext(context, reportUnit, reportUnit.getURIString(), inMemoryUnit);
        try {
            Map unitResources = this.loadFinalResources(context, reportUnit);
            OrigContextClassLoader origContext = this.setContextClassLoader(context, unitResources, inMemoryUnit);
            try {
                Query query;
                JasperReport report = this.getJasperReport(context, reportUnit, inMemoryUnit);
                Map reportParameters = this.getReportParameters(context, parameters);
                this.setReportTemplates(context, unitResources, reportParameters);
                ReportDataSource datasource = null;
                ResourceReference queryRef = reportUnit.getQuery();
                Query query2 = query = queryRef == null ? null : (Query)this.getFinalResource(context, queryRef);
                if (query != null && query.getDataSource() != null) {
                    datasource = (ReportDataSource)this.getFinalResource(context, query.getDataSource());
                }
                ResourceReference dsRef = reportUnit.getDataSource();
                if (datasource == null && dsRef != null) {
                    datasource = (ReportDataSource)this.getFinalResource(context, dsRef);
                }
                ReportUnitResult reportUnitResult = this.fillReport(context, report, reportParameters, datasource, query);
                this.revert(origContext);
                return reportUnitResult;
            }
            catch (Throwable throwable) {
                this.revert(origContext);
                throw throwable;
            }
        }
        finally {
            RepositoryUtil.clearThreadRepositoryContext();
        }
    }

    protected Map getReportParameters(ExecutionContext context, Map requestParameters) {
        User user;
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put("REPORT_URL_HANDLER_FACTORY", RepositoryURLHandlerFactory.getInstance());
        if (context != null && context.getLocale() != null) {
            reportParameters.put("REPORT_LOCALE", context.getLocale());
        }
        if (context != null && context.getTimeZone() != null) {
            reportParameters.put("REPORT_TIME_ZONE", context.getTimeZone());
        }
        if (this.getSecurityContextProvider() != null && (user = this.getSecurityContextProvider().getContextUser()) != null) {
            user.setPassword(null);
            reportParameters.put(this.getLoggedInUserReportParameterName(), user);
        }
        if (requestParameters != null) {
            reportParameters.putAll(requestParameters);
        }
        return reportParameters;
    }

    protected void setReportTemplates(ExecutionContext context, Map unitResources, Map reportParameters) {
        if (!reportParameters.containsKey("REPORT_TEMPLATES")) {
            ArrayList<JRTemplate> templates = new ArrayList<JRTemplate>();
            Iterator it = unitResources.values().iterator();
            while (it.hasNext()) {
                FileResource resource = (FileResource)it.next();
                if (!resource.getFileType().equals("jrtx")) continue;
                JRTemplate template = this.loadTemplate(context, resource);
                templates.add(template);
            }
            reportParameters.put("REPORT_TEMPLATES", templates);
        }
    }

    protected JRTemplate loadTemplate(ExecutionContext context, FileResource resource) {
        InputStream templateDataStream = this.getFileResourceDataStream(context, resource);
        try {
            return JRXmlTemplateLoader.load((InputStream)templateDataStream);
        }
        catch (JRRuntimeException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected void revert(OrigContextClassLoader origContext) {
        if (origContext.set) {
            Thread.currentThread().setContextClassLoader(origContext.origClassLoader);
            Iterator it = origContext.jars.iterator();
            while (it.hasNext()) {
                RepositoryCacheMap.CacheObject cacheJarFile = (RepositoryCacheMap.CacheObject)it.next();
                if (cacheJarFile.isCached()) continue;
                JarFile jarFile = (JarFile)cacheJarFile.getObject();
                this.dispose(jarFile);
            }
        }
    }

    protected OrigContextClassLoader setContextClassLoader(ExecutionContext context, ReportUnit reportUnit, boolean inMemoryUnit) {
        Map unitResources = this.loadFinalResources(context, reportUnit);
        return this.setContextClassLoader(context, unitResources, inMemoryUnit);
    }

    protected Map loadFinalResources(ExecutionContext context, ReportUnit reportUnit) {
        List resources = reportUnit.getResources();
        LinkedHashMap<ResourceReference, FileResource> finalResources = new LinkedHashMap<ResourceReference, FileResource>();
        if (resources != null && !resources.isEmpty()) {
            Iterator it = resources.iterator();
            while (it.hasNext()) {
                ResourceReference resRef = (ResourceReference)it.next();
                FileResource resource = this.getFinalFileResource(context, resRef);
                finalResources.put(resRef, resource);
            }
        }
        return finalResources;
    }

    protected OrigContextClassLoader setContextClassLoader(ExecutionContext context, Map unitResources, boolean inMemoryUnit) {
        OrigContextClassLoader origContext;
        ClassLoader jarsClassLoader;
        Thread thread = Thread.currentThread();
        ClassLoader origClassLoader = thread.getContextClassLoader();
        ClassLoader newClassLoader = null;
        List jarFiles = this.getJarFiles(context, unitResources, !inMemoryUnit);
        if (jarFiles.isEmpty()) {
            jarsClassLoader = origClassLoader;
        } else {
            newClassLoader = jarsClassLoader = this.getJarsClassLoader(origClassLoader, jarFiles);
        }
        Map resourceBundleKeys = this.getResourceBundleKeys(context, unitResources);
        if (!resourceBundleKeys.isEmpty()) {
            newClassLoader = this.getResourcesClassLoader(jarsClassLoader, resourceBundleKeys, inMemoryUnit);
        }
        if (newClassLoader == null) {
            origContext = OrigContextClassLoader.NOT_SET;
        } else {
            origContext = new OrigContextClassLoader(origClassLoader, jarFiles);
            thread.setContextClassLoader(newClassLoader);
        }
        return origContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassLoader getJarsClassLoader(ClassLoader origClassLoader, List jarFiles) {
        ClassLoader classLoader;
        boolean caching;
        RepositoryCacheMap.CacheObject cacheJarFile;
        Iterator it = jarFiles.iterator();
        for (caching = true; caching && it.hasNext(); caching &= cacheJarFile.isCached()) {
            cacheJarFile = (RepositoryCacheMap.CacheObject)it.next();
        }
        if (caching) {
            Map childrenClassLoaders;
            ReferenceMap referenceMap = this.jarsClassLoaderCache;
            synchronized (referenceMap) {
                childrenClassLoaders = (Map)this.jarsClassLoaderCache.get((Object)origClassLoader);
                if (childrenClassLoaders == null) {
                    childrenClassLoaders = new ReferenceMap(0, 1);
                    this.jarsClassLoaderCache.put((Object)origClassLoader, (Object)childrenClassLoaders);
                }
            }
            Object classLoaderKey = this.getJarFileNames(jarFiles);
            Map map = childrenClassLoaders;
            synchronized (map) {
                classLoader = (ClassLoader)childrenClassLoaders.get(classLoaderKey);
                if (classLoader == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating class loader for parent " + origClassLoader + " and jars " + classLoaderKey));
                    }
                    classLoader = this.createJarsClassLoader(origClassLoader, jarFiles);
                    childrenClassLoaders.put(classLoaderKey, classLoader);
                }
            }
        }
        classLoader = this.createJarsClassLoader(origClassLoader, jarFiles);
        return classLoader;
    }

    protected ClassLoader createJarsClassLoader(ClassLoader origClassLoader, List jarFiles) {
        JarFile[] jars = new JarFile[jarFiles.size()];
        int i = 0;
        Iterator it = jarFiles.iterator();
        while (it.hasNext()) {
            jars[i] = (JarFile)((RepositoryCacheMap.CacheObject)it.next()).getObject();
            ++i;
        }
        return new JarsClassLoader(jars, origClassLoader, this.reportJarsProtectionDomainProvider.getProtectionDomain());
    }

    private Object getJarFileNames(List jarFiles) {
        ArrayList<String> jarFileNames = new ArrayList<String>(jarFiles.size());
        Iterator it = jarFiles.iterator();
        while (it.hasNext()) {
            JarFile jar = (JarFile)((RepositoryCacheMap.CacheObject)it.next()).getObject();
            jarFileNames.add(jar.getName());
        }
        return jarFileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassLoader getResourcesClassLoader(ClassLoader parent, Map resourceBundleKeys, boolean inMemoryUnit) {
        ClassLoader repositoryResourceClassLoader;
        if (inMemoryUnit) {
            repositoryResourceClassLoader = new RepositoryResourceClassLoader(parent, resourceBundleKeys, true);
        } else {
            Map childrenClassLoaders;
            Object object = this.resourcesClassLoaderCache;
            synchronized (object) {
                childrenClassLoaders = (Map)this.resourcesClassLoaderCache.get((Object)parent);
                if (childrenClassLoaders == null) {
                    childrenClassLoaders = new ReferenceMap(0, 1);
                    this.resourcesClassLoaderCache.put((Object)parent, (Object)childrenClassLoaders);
                }
            }
            object = childrenClassLoaders;
            synchronized (object) {
                repositoryResourceClassLoader = (ClassLoader)childrenClassLoaders.get(resourceBundleKeys);
                if (repositoryResourceClassLoader == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating class loader for parent " + parent + " and resources " + resourceBundleKeys));
                    }
                    repositoryResourceClassLoader = new RepositoryResourceClassLoader(parent, resourceBundleKeys, false);
                    childrenClassLoaders.put(resourceBundleKeys, repositoryResourceClassLoader);
                }
            }
        }
        return repositoryResourceClassLoader;
    }

    protected List getJarFiles(ExecutionContext context, Map unitResources, boolean cache) {
        ArrayList<RepositoryCacheMap.CacheObject> jarFiles = new ArrayList<RepositoryCacheMap.CacheObject>();
        Iterator it = unitResources.values().iterator();
        while (it.hasNext()) {
            FileResource resource = (FileResource)it.next();
            if (!resource.getFileType().equals("jar")) continue;
            RepositoryCacheMap.CacheObject cacheJarFile = this.getCacheJarFile(context, resource, cache);
            jarFiles.add(cacheJarFile);
        }
        return jarFiles;
    }

    protected Map getResourceBundleKeys(ExecutionContext context, Map unitResources) {
        HashMap<String, RepositoryResourceKey> resourceBundleKeys = new HashMap<String, RepositoryResourceKey>();
        Iterator it = unitResources.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ResourceReference resRef = (ResourceReference)entry.getKey();
            FileResource finalResource = (FileResource)entry.getValue();
            if (!finalResource.getFileType().equals("prop")) continue;
            String resName = resRef.isLocal() ? resRef.getLocalResource().getName() : finalResource.getName();
            resourceBundleKeys.put(resName, new RepositoryResourceKey((Resource)finalResource));
        }
        return resourceBundleKeys;
    }

    protected JasperReport getJasperReport(ExecutionContext context, ReportUnit reportUnit, boolean inMemoryUnit) {
        FileResource reportRes = (FileResource)this.getFinalResource(context, reportUnit.getMainReport());
        try {
            JasperReport report;
            if (inMemoryUnit) {
                InputStream fileResourceData = this.getFileResourceDataStream(context, reportRes);
                report = this.compileReport(fileResourceData);
            } else {
                InputStream compiledReport = this.getCompiledReport(context, reportRes);
                report = (JasperReport)JRLoader.loadObject((InputStream)compiledReport);
            }
            return report;
        }
        catch (JRException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected ReportUnitResult fillReport(ExecutionContext context, JasperReport report, Map reportParameters, ReportDataSource datasource, Query query) {
        ReportDataSourceService dataSourceService = null;
        boolean dsClosing = false;
        try {
            if (datasource != null) {
                dataSourceService = this.createDataSourceService(datasource);
                dataSourceService.setReportParameterValues(reportParameters);
            }
            JasperPrint print = query == null ? JasperFillManager.fillReport((JasperReport)report, (Map)reportParameters) : this.fillQueryReport(context, report, reportParameters, query);
            dsClosing = true;
            if (dataSourceService != null) {
                dataSourceService.closeConnection();
                dataSourceService = null;
            }
            ReportUnitResult reportUnitResult = new ReportUnitResult(print, (JRVirtualizer)reportParameters.get("REPORT_VIRTUALIZER"));
            return reportUnitResult;
        }
        catch (JRException e) {
            log.error((Object)"Error while filling report", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        finally {
            if (!dsClosing && dataSourceService != null) {
                try {
                    dataSourceService.closeConnection();
                }
                catch (Exception e) {
                    log.error((Object)"Error while closing data source connection", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JasperPrint fillQueryReport(ExecutionContext context, JasperReport report, Map reportParameters, Query query) throws JRException {
        JRQueryExecuter queryExecuter = JRQueryExecuterAdapter.createQueryExecuter(report, reportParameters, query);
        boolean closing = false;
        try {
            JRDataSource reportDatasource = queryExecuter.createDatasource();
            JasperPrint printReport = JasperFillManager.fillReport((JasperReport)report, (Map)reportParameters, (JRDataSource)reportDatasource);
            closing = true;
            queryExecuter.close();
            JasperPrint jasperPrint = printReport;
            return jasperPrint;
        }
        finally {
            if (!closing) {
                queryExecuter.close();
            }
        }
    }

    public ReportDataSourceService createDataSourceService(ReportDataSource dataSource) {
        ReportDataSourceServiceFactory factory = (ReportDataSourceServiceFactory)this.getDataSourceServiceFactories().getBean(dataSource.getClass());
        return factory.createService(dataSource);
    }

    public Resource[] getResources(ResourceReference jrxmlReference) {
        FileResource jrxml = (FileResource)this.getFinalResource(null, jrxmlReference);
        return ResourceCollector.getResources(this.getFileResourceDataStream(null, jrxml));
    }

    protected Resource getRepositoryResource(ExecutionContext context, String uri) {
        return this.getRepositoryService().getResource(context, uri);
    }

    protected Resource getFinalResource(ExecutionContext context, ResourceReference res) {
        Resource finalRes = res.isLocal() ? res.getLocalResource() : this.getRepositoryResource(context, res.getReferenceURI());
        return finalRes;
    }

    protected FileResource getFinalFileResource(ExecutionContext context, ResourceReference resRef) {
        FileResource res = (FileResource)this.getFinalResource(context, resRef);
        while (res.isReference()) {
            res = (FileResource)this.getRepositoryResource(context, res.getReferenceURI());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationResult validate(ExecutionContext context, ReportUnit reportUnit) {
        OrigContextClassLoader origContext = this.setContextClassLoader(context, reportUnit, true);
        ValidationResultImpl result = new ValidationResultImpl();
        try {
            List resources;
            ResourceReference mainReport = reportUnit.getMainReport();
            if (mainReport != null) {
                this.validateJRXML(context, result, mainReport);
            }
            if ((resources = reportUnit.getResources()) != null && !resources.isEmpty()) {
                Iterator iter = resources.iterator();
                while (iter.hasNext()) {
                    ResourceReference resource = (ResourceReference)iter.next();
                    this.validateJRXML(context, result, resource);
                }
            }
        }
        finally {
            this.revert(origContext);
        }
        return result;
    }

    protected void validateJRXML(ExecutionContext context, ValidationResultImpl result, ResourceReference resourceRef) {
        FileResource resource = this.getFinalFileResource(context, resourceRef);
        if (resource.getFileType().equals("jrxml")) {
            try {
                JasperCompileManager.compileReport((InputStream)this.getFileResourceDataStream(context, resource));
            }
            catch (JRException e) {
                ValidationDetailImpl detail = new ValidationDetailImpl();
                detail.setValidationClass(class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource = EngineServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource);
                detail.setName(resource.getName());
                detail.setLabel(resource.getLabel());
                detail.setResult("ERROR");
                detail.setException((Exception)((Object)e));
                detail.setMessage(e.getMessage());
                result.addValidationDetail((ValidationDetail)detail);
            }
        }
    }

    public ReportUnitResult executeReport(ExecutionContext context, String reportUnitURI, Map parameters) {
        ReportUnit reportUnit = (ReportUnit)this.getRepositoryResource(context, reportUnitURI);
        return this.fillReport(context, reportUnit, parameters, false);
    }

    public ReportUnitResult executeReport(ExecutionContext context, ReportUnit reportUnit, Map parameters) {
        return this.fillReport(context, reportUnit, parameters, true);
    }

    public InputStream getCompiledReport(ExecutionContext context, InputStream jrxmlData) {
        JasperReport report = this.compileReport(jrxmlData);
        byte[] reportBytes = this.reportBytes(report);
        return new ByteArrayInputStream(reportBytes);
    }

    protected JasperReport compileReport(InputStream jrxmlData) {
        try {
            JasperDesign design = JRXmlLoader.load((InputStream)jrxmlData);
            JasperReport report = JasperCompileManager.compileReport((JasperDesign)design);
            return report;
        }
        catch (JRException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected InputStream getCompiledReport(ExecutionContext context, FileResource jrxml) {
        return this.compiledReportsCache.cache(context, jrxml, this.cacheableCompiledReports);
    }

    protected byte[] reportBytes(JasperReport report) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JRSaver.saveObject((Object)report, (OutputStream)bout);
            byte[] reportBytes = bout.toByteArray();
            return reportBytes;
        }
        catch (JRException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    public InputStream getCompiledReport(ExecutionContext context, String jrxmlURI) {
        return this.compiledReportsCache.cache(context, jrxmlURI, this.cacheableCompiledReports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JasperReport getMainJasperReport(ExecutionContext context, String reportUnitURI) {
        ReportUnit reportUnit = (ReportUnit)this.getRepositoryResource(context, reportUnitURI);
        OrigContextClassLoader origContext = this.setContextClassLoader(context, reportUnit, false);
        try {
            JasperReport jasperReport;
            JasperReport jasperReport2 = jasperReport = this.getJasperReport(context, reportUnit, false);
            return jasperReport2;
        }
        finally {
            this.revert(origContext);
        }
    }

    public void release() {
        this.tempJarFiles.release();
    }

    protected void dispose(JarFile jarFile) {
        try {
            jarFile.close();
        }
        catch (IOException e) {
            log.warn((Object)("Unable to close jar file \"" + jarFile.getName() + "\""), (Throwable)e);
        }
        File file = new File(jarFile.getName());
        if (file.exists() && !file.delete()) {
            log.warn((Object)("Unable to delete jar file \"" + jarFile.getName() + "\""));
        }
    }

    public void clearCaches(Class resourceItf, String resourceURI) {
        if ((class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource = EngineServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource).isAssignableFrom(resourceItf)) {
            this.compiledReportsCache.clearCache(resourceURI, this.cacheableCompiledReports);
            this.tempJarFiles.remove(resourceURI);
        }
    }

    public String getLoggedInUserReportParameterName() {
        return this.loggedInUserReportParameterName;
    }

    public void setLoggedInUserReportParameterName(String loggedInUserReportParameterName) {
        this.loggedInUserReportParameterName = loggedInUserReportParameterName;
    }

    public SecurityContextProvider getSecurityContextProvider() {
        return this.securityContextProvider;
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedMap executeQuery(ExecutionContext context, ResourceReference queryReference, String keyColumn, String[] resultColumns, ResourceReference defaultDataSourceReference) {
        Query query = (Query)this.getFinalResource(context, queryReference);
        ResourceReference dataSourceReference = query.getDataSource();
        if (dataSourceReference == null) {
            dataSourceReference = defaultDataSourceReference;
        }
        if (dataSourceReference == null) {
            return null;
        }
        ReportDataSource dataSource = (ReportDataSource)this.getFinalResource(context, dataSourceReference);
        ReportDataSourceService dataSourceService = this.createDataSourceService(dataSource);
        boolean dsClosing = false;
        try {
            HashMap parameters = new HashMap();
            dataSourceService.setReportParameterValues(parameters);
            OrderedMap result = JRQueryExecuterAdapter.executeQuery(query, keyColumn, resultColumns, parameters);
            dsClosing = true;
            if (dataSourceService != null) {
                dataSourceService.closeConnection();
                dataSourceService = null;
            }
            OrderedMap orderedMap = result;
            return orderedMap;
        }
        finally {
            if (!dsClosing && dataSourceService != null) {
                try {
                    dataSourceService.closeConnection();
                }
                catch (Exception e) {
                    log.error((Object)"Error while closing data source connection", (Throwable)e);
                }
            }
        }
    }

    public ResourceLookup[] getDataSources(ExecutionContext context, String queryLanguage) {
        ResourceLookup[] datasources;
        if (queryLanguage == null) {
            datasources = this.repository.findResource(context, FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportDataSource = EngineServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportDataSource)));
        } else {
            Set dataSourceTypes = this.dataSourceServiceFactories.getSupportingDataSourceTypes(queryLanguage);
            if (dataSourceTypes == null || dataSourceTypes.isEmpty()) {
                datasources = null;
            } else {
                FilterCriteria[] criteria = new FilterCriteria[dataSourceTypes.size()];
                int i = 0;
                Iterator it = dataSourceTypes.iterator();
                while (it.hasNext()) {
                    Class type = (Class)it.next();
                    criteria[i] = FilterCriteria.createFilter((Class)type);
                    ++i;
                }
                datasources = this.repository.findResources(context, criteria);
            }
        }
        return datasources;
    }

    public String getQueryLanguage(ExecutionContext context, ResourceReference jrxmlResource) {
        JasperDesign jasperDesign = this.loadJRXML(context, jrxmlResource);
        JRQuery query = jasperDesign.getQuery();
        return query == null ? null : query.getLanguage();
    }

    protected JasperDesign loadJRXML(ExecutionContext context, ResourceReference jrxmlResource) {
        JasperDesign jasperDesign;
        FileResource jrxmlRes = this.getFinalFileResource(context, jrxmlResource);
        InputStream jrxmlData = this.getFileResourceDataStream(context, jrxmlRes);
        boolean close = true;
        try {
            jasperDesign = JRXmlLoader.load((InputStream)jrxmlData);
            close = false;
            jrxmlData.close();
        }
        catch (JRException e) {
            log.error((Object)"Error parsing JRXML", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        finally {
            if (close) {
                try {
                    jrxmlData.close();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        return jasperDesign;
    }

    public Set getDataSourceTypes(ExecutionContext context, String queryLanguage) {
        return this.dataSourceServiceFactories.getSupportingDataSourceTypes(queryLanguage);
    }

    /*
     * Loose catch block
     */
    public Map getReportInputControlDefaultValues(ExecutionContext context, String reportURI, Map initialParameters) {
        ReportUnit reportUnit = (ReportUnit)this.getRepositoryResource(context, reportURI);
        List inputControls = reportUnit.getInputControls();
        if (inputControls == null || inputControls.isEmpty()) {
            return null;
        }
        this.setThreadRepositoryContext(context, reportUnit, reportUnit.getURIString(), false);
        try {
            OrigContextClassLoader origContext = this.setContextClassLoader(context, reportUnit, false);
            try {
                JasperReport report = this.getJasperReport(context, reportUnit, false);
                initialParameters = this.getReportParameters(context, initialParameters);
                Map paramValues = JRParameterDefaultValuesEvaluator.evaluateParameterDefaultValues((JasperReport)report, (Map)initialParameters);
                HashMap inputValues = new HashMap();
                Iterator it = inputControls.iterator();
                while (it.hasNext()) {
                    ResourceReference inputControlRef = (ResourceReference)it.next();
                    InputControl inputControl = (InputControl)this.getFinalResource(context, inputControlRef);
                    Object value = paramValues.get(inputControl.getName());
                    inputValues.put(inputControl.getName(), value);
                }
                HashMap hashMap = inputValues;
                return hashMap;
            }
            catch (JRException e) {
                throw new JSExceptionWrapper((Exception)((Object)e));
            }
            finally {
                this.revert(origContext);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            RepositoryUtil.clearThreadRepositoryContext();
        }
    }

    public ProtectionDomainProvider getReportJarsProtectionDomainProvider() {
        return this.reportJarsProtectionDomainProvider;
    }

    public void setReportJarsProtectionDomainProvider(ProtectionDomainProvider protectionDomainProvider) {
        this.reportJarsProtectionDomainProvider = protectionDomainProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class OrigContextClassLoader {
        public final boolean set;
        public final ClassLoader origClassLoader;
        public final List jars;
        public static final OrigContextClassLoader NOT_SET = new OrigContextClassLoader(false);

        private OrigContextClassLoader(boolean set) {
            this.set = set;
            this.origClassLoader = null;
            this.jars = null;
        }

        public OrigContextClassLoader(ClassLoader origClassLoader, List jars) {
            this.set = true;
            this.origClassLoader = origClassLoader;
            this.jars = jars;
        }
    }

    protected final class TempJarFileCacheObject
    implements RepositoryCacheMap.ObjectCache {
        protected TempJarFileCacheObject() {
        }

        public boolean isValid(Object o) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object create(ExecutionContext context, FileResource res) {
            try {
                File tempFile = File.createTempFile("report_jar", ".jar");
                tempFile.deleteOnExit();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Created temp jar file \"" + tempFile.getPath() + "\" for resource \"" + res.getURIString() + "\""));
                }
                byte[] data = EngineServiceImpl.this.getFileResourceData(context, res);
                BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(tempFile));
                try {
                    ((OutputStream)fileOut).write(data);
                    ((OutputStream)fileOut).flush();
                }
                finally {
                    ((OutputStream)fileOut).close();
                }
                JarFile jarFile = new JarFile(tempFile);
                return jarFile;
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                throw new JSExceptionWrapper((Exception)e);
            }
        }

        public void release(Object o) {
            EngineServiceImpl.this.dispose((JarFile)o);
        }
    }

    protected class CacheableCompiledReports
    implements RepositoryCacheableItem {
        private static final String CACHE_NAME = "JasperReport";

        protected CacheableCompiledReports() {
        }

        public String getCacheName() {
            return CACHE_NAME;
        }

        public byte[] getData(ExecutionContext context, FileResource resource) {
            InputStream jrxmlData = EngineServiceImpl.this.getFileResourceDataStream(context, resource);
            JasperReport report = EngineServiceImpl.this.compileReport(jrxmlData);
            byte[] reportBytes = EngineServiceImpl.this.reportBytes(report);
            return reportBytes;
        }
    }
}

