/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceServiceFactory;
import java.util.TimeZone;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JndiJdbcReportDataSourceServiceFactory
implements ReportDataSourceServiceFactory {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$engine$jasperreports$service$impl$JndiJdbcReportDataSourceServiceFactory == null ? (class$com$jaspersoft$jasperserver$api$engine$jasperreports$service$impl$JndiJdbcReportDataSourceServiceFactory = JndiJdbcReportDataSourceServiceFactory.class$("com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JndiJdbcReportDataSourceServiceFactory")) : class$com$jaspersoft$jasperserver$api$engine$jasperreports$service$impl$JndiJdbcReportDataSourceServiceFactory));
    private Context ctx = null;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$engine$jasperreports$service$impl$JndiJdbcReportDataSourceServiceFactory;

    public JndiJdbcReportDataSourceServiceFactory() {
        try {
            this.ctx = new InitialContext();
        }
        catch (NamingException e) {
            log.error((Object)e);
            throw new JSException((Throwable)e);
        }
    }

    public ReportDataSourceService createService(ReportDataSource dataSource) {
        try {
            if (!(dataSource instanceof JndiJdbcReportDataSource)) {
                throw new JSException("jsexception.invalid.jndi.jdbc.datasource", new Object[]{dataSource.getClass()});
            }
            JndiJdbcReportDataSource jndiDataSource = (JndiJdbcReportDataSource)dataSource;
            String jndiName = jndiDataSource.getJndiName();
            DataSource ds = (DataSource)this.ctx.lookup("java:comp/env/" + jndiName);
            TimeZone timeZone = jndiDataSource.getTimezone() != null ? TimeZone.getTimeZone(jndiDataSource.getTimezone()) : null;
            return new JdbcDataSourceService(ds, timeZone);
        }
        catch (NamingException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

