/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.service.impl.BeanForInterfaceImplementationFactoryImpl;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.DataSourceServiceDefinition;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.DataSourceServiceFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class DataSourceServiceFactoryImpl
extends BeanForInterfaceImplementationFactoryImpl
implements DataSourceServiceFactory,
InitializingBean {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$DataSourceServiceFactoryImpl == null ? (class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$DataSourceServiceFactoryImpl = DataSourceServiceFactoryImpl.class$("com.jaspersoft.jasperserver.api.engine.jasperreports.util.DataSourceServiceFactoryImpl")) : class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$DataSourceServiceFactoryImpl));
    private Map serviceDefinitionMap;
    private Set universalTypes;
    private Map languageTypes;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$DataSourceServiceFactoryImpl;

    public void afterPropertiesSet() {
        this.setBeanInterfaceMappings();
        this.collectLanguageTypes();
    }

    protected void setBeanInterfaceMappings() {
        HashMap<String, String> beanItfMap = new HashMap<String, String>();
        Iterator it = this.serviceDefinitionMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String itf = (String)entry.getKey();
            DataSourceServiceDefinition serviceDef = (DataSourceServiceDefinition)entry.getValue();
            beanItfMap.put(itf, serviceDef.getServiceBeanName());
        }
        this.setBeanForInterfaceMappings(beanItfMap);
    }

    protected void collectLanguageTypes() {
        this.languageTypes = new HashMap();
        this.universalTypes = new HashSet();
        Iterator it = this.serviceDefinitionMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String itf = (String)entry.getKey();
            DataSourceServiceDefinition serviceDef = (DataSourceServiceDefinition)entry.getValue();
            if (serviceDef.isAnyLanguage()) {
                this.universalTypes.add(this.resolveType(itf));
            }
            this.collectTypes(itf, serviceDef);
        }
    }

    protected void collectTypes(String itf, DataSourceServiceDefinition serviceDef) {
        Set languages = serviceDef.getSupportedQueryLanguages();
        if (languages != null) {
            Iterator langIt = languages.iterator();
            while (langIt.hasNext()) {
                String language = (String)langIt.next();
                HashSet<Class> langTypes = (HashSet<Class>)this.languageTypes.get(language);
                if (langTypes == null) {
                    langTypes = new HashSet<Class>();
                    this.languageTypes.put(language, langTypes);
                }
                langTypes.add(this.resolveType(itf));
            }
        }
    }

    protected Class resolveType(String itf) {
        try {
            return Class.forName(itf, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public Set getSupportingDataSourceTypes(String queryLanguage) {
        HashSet types = new HashSet();
        Set langTypes = (Set)this.languageTypes.get(queryLanguage);
        if (langTypes != null) {
            types.addAll(langTypes);
        }
        types.addAll(this.universalTypes);
        return types;
    }

    public Map getServiceDefinitionMap() {
        return this.serviceDefinitionMap;
    }

    public void setServiceDefinitionMap(Map serviceBeansMap) {
        this.serviceDefinitionMap = serviceBeansMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

