/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBaseDataset;
import net.sf.jasperreports.engine.base.JRBaseField;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.base.JRBaseParameter;
import net.sf.jasperreports.engine.base.JRBaseQuery;
import net.sf.jasperreports.engine.base.JRBaseQueryChunk;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRQueryExecuterAdapter {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$JRQueryExecuterAdapter == null ? (class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$JRQueryExecuterAdapter = JRQueryExecuterAdapter.class$("com.jaspersoft.jasperserver.api.engine.jasperreports.util.JRQueryExecuterAdapter")) : class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$JRQueryExecuterAdapter));
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$JRQueryExecuterAdapter;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$sql$Connection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrderedMap executeQuery(Query query, String keyColumn, String[] resultColumns, Map parameterValues) {
        LinkedMap linkedMap;
        JRQueryExecuterFactory queryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory((String)query.getLanguage());
        JRParameter[] dsParameters = JRQueryExecuterAdapter.getDatasetParameters(queryExecuterFactory, parameterValues);
        JRField[] fields = JRQueryExecuterAdapter.getDatasetFields(keyColumn, resultColumns);
        JSQuery dsQuery = new JSQuery(query);
        JSDataset dataset = new JSDataset(query.getName(), dsParameters, fields, (JRQuery)dsQuery);
        HashMap<String, JRParameter> parametersMap = new HashMap<String, JRParameter>();
        for (int i = 0; i < dsParameters.length; ++i) {
            JRParameter parameter = dsParameters[i];
            parametersMap.put(parameter.getName(), parameter);
        }
        JRQueryExecuter executer = queryExecuterFactory.createQueryExecuter((JRDataset)dataset, parametersMap);
        try {
            JRDataSource ds = executer.createDatasource();
            LinkedMap values = new LinkedMap();
            while (ds.next()) {
                Object valueColumn = ds.getFieldValue(dataset.getField(keyColumn));
                String[] visibleColumnValues = new String[resultColumns.length];
                for (int idx = 0; idx < resultColumns.length; ++idx) {
                    visibleColumnValues[idx] = (String)ds.getFieldValue(dataset.getField(resultColumns[idx]));
                }
                values.put(valueColumn, visibleColumnValues);
            }
            linkedMap = values;
        }
        catch (Throwable throwable) {
            try {
                executer.close();
                throw throwable;
            }
            catch (JRException e) {
                log.error((Object)"Error while executing query", (Throwable)e);
                throw new JSExceptionWrapper((Exception)((Object)e));
            }
        }
        executer.close();
        return linkedMap;
    }

    protected static JRField[] getDatasetFields(String keyColumn, String[] resultColumns) {
        JRField[] fields = new JRField[resultColumns.length + 1];
        fields[0] = new ColumnField(keyColumn, class$java$lang$Object == null ? (class$java$lang$Object = JRQueryExecuterAdapter.class$("java.lang.Object")) : class$java$lang$Object);
        for (int idx = 0; idx < resultColumns.length; ++idx) {
            fields[idx + 1] = new ColumnField(resultColumns[idx], class$java$lang$String == null ? JRQueryExecuterAdapter.class$("java.lang.String") : class$java$lang$String);
        }
        return fields;
    }

    protected static JRParameter[] getDatasetParameters(JRQueryExecuterFactory queryExecuterFactory, Map parameterValues) {
        Object[] builtinParameters;
        boolean jdbcConnectionParam = parameterValues.containsKey("REPORT_CONNECTION");
        ArrayList<ValueParameter> dsParameters = new ArrayList<ValueParameter>();
        dsParameters.add(new ValueParameter("REPORT_PARAMETERS_MAP", class$java$util$Map == null ? (class$java$util$Map = JRQueryExecuterAdapter.class$("java.util.Map")) : class$java$util$Map, parameterValues));
        dsParameters.add(new ValueParameter("REPORT_MAX_COUNT", class$java$sql$Connection == null ? (class$java$sql$Connection = JRQueryExecuterAdapter.class$("java.sql.Connection")) : class$java$sql$Connection, null));
        if (jdbcConnectionParam) {
            Object value = parameterValues.get("REPORT_CONNECTION");
            dsParameters.add(new ValueParameter("REPORT_CONNECTION", class$java$sql$Connection == null ? (class$java$sql$Connection = JRQueryExecuterAdapter.class$("java.sql.Connection")) : class$java$sql$Connection, value));
        }
        if ((builtinParameters = queryExecuterFactory.getBuiltinParameters()) != null) {
            for (int i = 0; i < builtinParameters.length - 1; i += 2) {
                String name = (String)builtinParameters[i];
                Class type = (Class)builtinParameters[i + 1];
                Object value = parameterValues.get(name);
                dsParameters.add(new ValueParameter(name, type, value));
            }
        }
        JRParameter[] params = new JRParameter[dsParameters.size()];
        return dsParameters.toArray(params);
    }

    public static JRQueryExecuter createQueryExecuter(JasperReport report, Map parameterValues, Query query) {
        try {
            JRQueryExecuterFactory queryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory((String)query.getLanguage());
            ReportQueryDataset dataset = new ReportQueryDataset(report, query, queryExecuterFactory);
            ShallowJRObjectFactory jrObjectFactory = new ShallowJRObjectFactory((JRDefaultStyleProvider)report);
            HashMap<String, ParameterValueDecorator> parametersMap = new HashMap<String, ParameterValueDecorator>();
            JRParameter[] parameters = dataset.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                JRParameter parameter = parameters[i];
                Object value = parameterValues.get(parameter.getName());
                ParameterValueDecorator parameterValue = new ParameterValueDecorator(parameter, value, jrObjectFactory);
                parametersMap.put(parameter.getName(), parameterValue);
            }
            JRQueryExecuter executer = queryExecuterFactory.createQueryExecuter((JRDataset)dataset, parametersMap);
            return executer;
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class ShallowJRObjectFactory
    extends JRBaseObjectFactory {
        protected ShallowJRObjectFactory(JRDefaultStyleProvider defaultStyleProvider) {
            super(defaultStyleProvider);
        }

        public JRExpression getExpression(JRExpression expression) {
            return expression;
        }
    }

    protected static class ParameterValueDecorator
    extends JRBaseParameter
    implements JRValueParameter {
        private final Object value;

        public ParameterValueDecorator(JRParameter parameter, Object value, JRBaseObjectFactory jrObjectFactory) {
            super(parameter, jrObjectFactory);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    protected static class ReportQueryDataset
    implements JRDataset {
        private final JRDataset reportDataset;
        private final JRParameter[] parameters;
        private final JRQuery query;

        public ReportQueryDataset(JasperReport report, Query query, JRQueryExecuterFactory queryExecuterFactory) {
            this.reportDataset = report.getMainDataset();
            this.query = this.getQuery(query);
            this.parameters = this.getParams(queryExecuterFactory);
        }

        private JRQuery getQuery(Query query) {
            JRDesignQuery designQuery = new JRDesignQuery();
            designQuery.setLanguage(query.getLanguage());
            designQuery.setText(query.getSql());
            return designQuery;
        }

        private JRParameter[] getParams(JRQueryExecuterFactory queryExecuterFactory) {
            JRParameter[] paramArray;
            Object[] builtinParameters = queryExecuterFactory.getBuiltinParameters();
            if (builtinParameters == null || builtinParameters.length == 0) {
                paramArray = this.reportDataset.getParameters();
            } else {
                int i;
                JRParameter[] reportParams = this.reportDataset.getParameters();
                ArrayList<Object> params = new ArrayList<Object>(reportParams.length + builtinParameters.length / 2);
                HashSet<String> paramNames = new HashSet<String>();
                for (i = 0; i < reportParams.length; ++i) {
                    JRParameter parameter = reportParams[i];
                    params.add(parameter);
                    paramNames.add(parameter.getName());
                }
                for (i = 0; i < builtinParameters.length - 1; i += 2) {
                    String name = (String)builtinParameters[i];
                    if (paramNames.contains(name)) continue;
                    Class type = (Class)builtinParameters[i + 1];
                    params.add((Object)new ValueParameter(name, type, null));
                }
                paramArray = new JRParameter[params.size()];
                paramArray = params.toArray(paramArray);
            }
            return paramArray;
        }

        public String getName() {
            return this.reportDataset.getName();
        }

        public String getScriptletClass() {
            return this.reportDataset.getScriptletClass();
        }

        public JRParameter[] getParameters() {
            return this.parameters;
        }

        public JRQuery getQuery() {
            return this.query;
        }

        public JRField[] getFields() {
            return this.reportDataset.getFields();
        }

        public JRVariable[] getVariables() {
            return this.reportDataset.getVariables();
        }

        public JRGroup[] getGroups() {
            return this.reportDataset.getGroups();
        }

        public boolean isMainDataset() {
            return true;
        }

        public String getResourceBundle() {
            return this.reportDataset.getResourceBundle();
        }

        public byte getWhenResourceMissingType() {
            return this.reportDataset.getWhenResourceMissingType();
        }

        public void setWhenResourceMissingType(byte type) {
        }

        public JRPropertiesMap getPropertiesMap() {
            return this.reportDataset.getPropertiesMap();
        }

        public JRExpression getFilterExpression() {
            return this.reportDataset.getFilterExpression();
        }

        public JRSortField[] getSortFields() {
            return this.reportDataset.getSortFields();
        }
    }

    protected static class ValueParameter
    extends JRBaseParameter
    implements JRValueParameter {
        private final Object value;

        public ValueParameter(String name, Class type, Object value) {
            this.name = name;
            this.valueClass = type;
            this.valueClassName = type.getName();
            this.isSystemDefined = true;
            this.isForPrompting = false;
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    protected static class JSDataset
    extends JRBaseDataset {
        private final Map fieldsMap;

        public JSDataset(String name, JRParameter[] parameters, JRField[] fields, JRQuery query) {
            super(false);
            this.name = name;
            this.parameters = parameters;
            this.fields = fields;
            this.query = query;
            this.fieldsMap = new HashMap();
            for (int i = 0; i < fields.length; ++i) {
                JRField field = fields[i];
                this.fieldsMap.put(field.getName(), field);
            }
        }

        public JRField getField(String column) {
            return (JRField)this.fieldsMap.get(column);
        }
    }

    protected static class JSQueryChunk
    extends JRBaseQueryChunk {
        public JSQueryChunk(String text) {
            this.text = text;
            this.type = 1;
        }
    }

    protected static class JSQuery
    extends JRBaseQuery {
        private final JRQueryChunk[] chunks;

        public JSQuery(String queryLanguage, String queryString) {
            this.language = queryLanguage;
            this.chunks = new JRQueryChunk[]{new JSQueryChunk(queryString)};
        }

        public JSQuery(Query query) {
            this(query.getLanguage(), query.getSql());
        }

        public JRQueryChunk[] getChunks() {
            return this.chunks;
        }
    }

    protected static class ColumnField
    extends JRBaseField {
        public ColumnField(String column, Class type) {
            this.name = column;
            this.valueClass = type;
            this.valueClassName = type.getName();
        }
    }
}

