/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JRBaseValueParameter;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JRTimezoneResultSetDataSource;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.query.JRJdbcQueryExecuter;
import org.quartz.TriggerUtils;

public class JRTimezoneJdbcQueryExecuter
extends JRJdbcQueryExecuter {
    private static InheritableThreadLocal parentTimezone = new InheritableThreadLocal();

    public JRTimezoneJdbcQueryExecuter(JRDataset dataset, Map map) {
        super(dataset, map);
        TimeZone timezone = (TimeZone)this.getValueParameter("DATABASE_TIMEZONE").getValue();
        if (timezone != null) {
            parentTimezone.set(timezone);
        }
    }

    protected JRValueParameter getValueParameter(String parameterName) {
        TimeZone timezone;
        JRValueParameter param = super.getValueParameter(parameterName);
        if (param.getValue() instanceof Date && (timezone = (TimeZone)parentTimezone.get()) != null) {
            Date initialDate = (Date)param.getValue();
            Date date = TriggerUtils.translateTime((Date)initialDate, (TimeZone)timezone, (TimeZone)TimeZone.getTimeZone("GMT"));
            initialDate.setTime(date.getTime());
            return new JRBaseValueParameter((JRParameter)param, initialDate);
        }
        return param;
    }

    public JRDataSource createDatasource() throws JRException {
        JRDataSource dataSource = super.createDatasource();
        TimeZone timezone = (TimeZone)parentTimezone.get();
        return new JRTimezoneResultSetDataSource(dataSource, timezone);
    }
}

