/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JarFileEntry;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JarURLStreamHandler;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JarsClassLoader
extends ClassLoader {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$JarsClassLoader == null ? (class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$JarsClassLoader = JarsClassLoader.class$("com.jaspersoft.jasperserver.api.engine.jasperreports.util.JarsClassLoader")) : class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$JarsClassLoader));
    private final JarURLStreamHandler urlStreamHandler = new JarURLStreamHandler();
    private final JarFile[] jars;
    private final ProtectionDomain protectionDomain;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$JarsClassLoader;

    public JarsClassLoader(JarFile[] jars, ClassLoader parent) {
        this(jars, parent, (class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$JarsClassLoader == null ? (class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$JarsClassLoader = JarsClassLoader.class$("com.jaspersoft.jasperserver.api.engine.jasperreports.util.JarsClassLoader")) : class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$JarsClassLoader).getProtectionDomain());
    }

    public JarsClassLoader(JarFile[] jars, ClassLoader parent, ProtectionDomain protectionDomain) {
        super(parent);
        this.jars = jars;
        this.protectionDomain = protectionDomain;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] classData;
        String path = name.replace('.', '/').concat(".class");
        JarFileEntry entry = this.findPath(path);
        if (entry == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            long size = entry.getSize();
            classData = size >= 0L ? StreamUtils.readData((InputStream)entry.getInputStream(), (int)((int)size)) : StreamUtils.readData((InputStream)entry.getInputStream());
        }
        catch (IOException e) {
            log.debug((Object)e, (Throwable)e);
            throw new ClassNotFoundException(name, e);
        }
        return this.defineClass(name, classData, 0, classData.length, this.protectionDomain);
    }

    protected JarFileEntry findPath(String path) {
        JarFileEntry entry = null;
        for (int i = 0; i < this.jars.length && entry == null; ++i) {
            entry = JarsClassLoader.getJarEntry(this.jars[i], path);
        }
        return entry;
    }

    protected URL findResource(String name) {
        JarFileEntry entry = this.findPath(name);
        return entry == null ? null : this.urlStreamHandler.createURL(entry);
    }

    protected Enumeration findResources(String name) throws IOException {
        Vector<URL> urls = new Vector<URL>();
        for (int i = 0; i < this.jars.length; ++i) {
            JarFileEntry entry = JarsClassLoader.getJarEntry(this.jars[i], name);
            if (entry == null) continue;
            urls.add(this.urlStreamHandler.createURL(entry));
        }
        return urls.elements();
    }

    protected static JarFileEntry getJarEntry(JarFile jar, String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        JarFileEntry jarEntry = null;
        JarEntry entry = jar.getJarEntry(name);
        if (entry != null) {
            jarEntry = new JarFileEntry(jar, entry);
        }
        return jarEntry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

