/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryCacheMap {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$RepositoryCacheMap == null ? (class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$RepositoryCacheMap = RepositoryCacheMap.class$("com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryCacheMap")) : class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$RepositoryCacheMap));
    private final RepositoryService repository;
    private final ObjectCache objectCache;
    private final Map map;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$RepositoryCacheMap;

    public RepositoryCacheMap(RepositoryService repository, ObjectCache objectCache) {
        this.repository = repository;
        this.objectCache = objectCache;
        this.map = Collections.synchronizedMap(new HashMap());
    }

    public CacheObject cache(ExecutionContext context, FileResource res, boolean cacheFirst) {
        Object ret;
        VersionObject val = null;
        if (cacheFirst) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Searching cache for " + res.getURIString() + ", version " + res.getVersion()));
            }
            val = (VersionObject)this.map.get(res.getURIString());
            if (log.isDebugEnabled()) {
                if (val == null) {
                    log.debug((Object)("Cache doesn't contain " + res.getURIString()));
                } else {
                    log.debug((Object)("Found in cache " + res.getURIString() + " with version " + val.version));
                }
            }
        }
        boolean cached = true;
        if (val != null && val.version >= res.getVersion() && (val.isReference() || this.objectCache.isValid(val.o))) {
            ret = val.o;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating cached object for " + res.getURIString() + ", version " + res.getVersion()));
            }
            if (res.isReference()) {
                FileResource ref = (FileResource)this.repository.getResource(context, res.getReferenceURI());
                CacheObject refCache = this.cache(context, ref, true);
                ret = refCache.getObject();
                if (cacheFirst) {
                    VersionObject value = new VersionObject(res.getReferenceURI(), res.getVersion());
                    this.put(res, value);
                }
            } else {
                ret = this.objectCache.create(context, res);
                if (cacheFirst) {
                    VersionObject value = new VersionObject(ret, res.getVersion());
                    this.put(res, value);
                } else {
                    cached = false;
                }
            }
        }
        return new CacheObject(ret, cached);
    }

    public void remove(String resourceURI) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing from cache " + resourceURI));
        }
        this.map.remove(resourceURI);
    }

    protected void put(FileResource res, VersionObject value) {
        VersionObject old = this.map.put(res.getURIString(), value);
        if (old != null && !old.isReference()) {
            this.objectCache.release(old.o);
        }
    }

    public void release() {
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            VersionObject val = (VersionObject)it.next();
            if (val.isReference()) continue;
            this.objectCache.release(val.o);
        }
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CacheObject {
        private final Object o;
        private final boolean cached;

        public CacheObject(Object o, boolean cached) {
            this.o = o;
            this.cached = cached;
        }

        public Object getObject() {
            return this.o;
        }

        public boolean isCached() {
            return this.cached;
        }
    }

    protected static class VersionObject {
        public final Object o;
        public final String referenceURI;
        public final int version;

        public VersionObject(Object o, int version) {
            this.o = o;
            this.referenceURI = null;
            this.version = version;
        }

        public VersionObject(String referenceURI, int version) {
            this.o = null;
            this.referenceURI = referenceURI;
            this.version = version;
        }

        public boolean isReference() {
            return this.referenceURI != null;
        }
    }

    public static interface ObjectCache {
        public boolean isValid(Object var1);

        public Object create(ExecutionContext var1, FileResource var2);

        public void release(Object var1);
    }
}

