/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FileResourceImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class ResourceCollector {
    private static final String REPO_URL_PROTOCOL = "repo:";
    private List resources = new ArrayList();
    private Set resourceNames = new HashSet();

    private ResourceCollector() {
    }

    public static Resource[] getResources(InputStream jrxmlStream) {
        JasperDesign jasperDesign = null;
        try {
            jasperDesign = JRXmlLoader.load((InputStream)jrxmlStream);
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        ResourceCollector collector = new ResourceCollector();
        collector.collect((JRReport)jasperDesign);
        return collector.getResources();
    }

    private Resource[] getResources() {
        return this.resources.toArray(new Resource[this.resources.size()]);
    }

    private void collect(JRReport report) {
        if (report != null) {
            JRStyle[] styles = report.getStyles();
            if (styles != null) {
                for (int i = 0; i < styles.length; ++i) {
                    this.collect(styles[i]);
                }
            }
            this.collect(report.getBackground());
            this.collect(report.getTitle());
            this.collect(report.getPageHeader());
            this.collect(report.getColumnHeader());
            this.collect(report.getDetail());
            this.collect(report.getColumnFooter());
            this.collect(report.getPageFooter());
            this.collect(report.getSummary());
            JRGroup[] groups = report.getGroups();
            if (groups != null) {
                for (int i = 0; i < groups.length; ++i) {
                    JRGroup group = groups[i];
                    this.collect(group.getGroupHeader());
                    this.collect(group.getGroupFooter());
                }
            }
        }
    }

    private void collect(JRStyle style) {
        this.collectFont(style.getOwnPdfFontName());
        JRConditionalStyle[] conditionalStyles = style.getConditionalStyles();
        if (conditionalStyles != null) {
            for (int i = 0; i < conditionalStyles.length; ++i) {
                this.collect((JRStyle)conditionalStyles[i]);
            }
        }
    }

    private void collect(JRBand band) {
        JRElement[] elements;
        if (band != null && (elements = band.getElements()) != null) {
            for (int i = 0; i < elements.length; ++i) {
                JRElement element = elements[i];
                if (element instanceof JRFont) {
                    JRFont font = (JRFont)element;
                    this.collectFont(font.getOwnPdfFontName());
                    continue;
                }
                if (element instanceof JRImage) {
                    JRImage image = (JRImage)element;
                    this.collectFromExpression(image.getExpression(), "img");
                    continue;
                }
                if (!(element instanceof JRSubreport)) continue;
                JRSubreport subreport = (JRSubreport)element;
                this.collectFromExpression(subreport.getExpression(), "jrxml");
            }
        }
    }

    private void collectFont(String pdfFontName) {
        String resourceName;
        if (pdfFontName != null && pdfFontName.startsWith(REPO_URL_PROTOCOL) && pdfFontName.indexOf(47) < 0 && !this.resourceNames.contains(resourceName = pdfFontName.substring(REPO_URL_PROTOCOL.length()))) {
            FileResourceImpl resource = new FileResourceImpl();
            resource.setName(resourceName);
            resource.setLabel(resource.getName());
            resource.setDescription(resource.getName());
            resource.setFileType("font");
            this.resources.add(resource);
            this.resourceNames.add(resourceName);
        }
    }

    private void collectFromExpression(JRExpression expression, String resourceType) {
        String resourceName;
        JRExpressionChunk chunk;
        if (expression != null && expression.getChunks() != null && expression.getChunks().length == 1 && (chunk = expression.getChunks()[0]).getType() == 1 && (resourceName = chunk.getText().trim()).startsWith("\"repo:") && resourceName.indexOf(47) < 0 && resourceName.endsWith("\"") && !this.resourceNames.contains(resourceName = resourceName.substring(REPO_URL_PROTOCOL.length() + 1, resourceName.length() - 1))) {
            FileResourceImpl resource = new FileResourceImpl();
            resource.setName(resourceName);
            resource.setLabel(resource.getName());
            resource.setDescription(resource.getName());
            resource.setFileType(resourceType);
            this.resources.add(resource);
            this.resourceNames.add(resourceName);
        }
    }
}

