/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util.repo;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.service.JSResourceNotFoundException;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryConnection
extends URLConnection {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$repo$RepositoryConnection == null ? (class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$repo$RepositoryConnection = RepositoryConnection.class$("com.jaspersoft.jasperserver.api.engine.jasperreports.util.repo.RepositoryConnection")) : class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$repo$RepositoryConnection));
    private final RepositoryContext repositoryContext;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$engine$jasperreports$util$repo$RepositoryConnection;

    public RepositoryConnection(RepositoryContext repository, URL url) {
        super(url);
        this.repositoryContext = repository;
    }

    public void connect() throws IOException {
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        try {
            FileResource resource;
            InputStream data = null;
            String path = this.url.getPath();
            if (!path.startsWith("/")) {
                ReportUnit reportUnit = this.repositoryContext.getReportUnit();
                resource = null;
                if (reportUnit != null) {
                    resource = reportUnit.getResourceLocal(path);
                }
                if (resource == null) {
                    path = this.repositoryContext.getContextURI() + "/" + path;
                } else if (resource.isReference()) {
                    path = resource.getReferenceURI();
                } else if (resource.hasData()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loading resource \"" + resource.getName() + "\" from in-memory report unit"));
                    }
                    data = resource.getDataStream();
                    if (resource.getFileType().equals("jrxml")) {
                        data = this.repositoryContext.getCompiledReportProvider().getCompiledReport(this.repositoryContext.getExecutionContext(), data);
                    }
                } else {
                    path = resource.getURIString();
                }
            }
            if (data == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading resource \"" + path + "\" from repository"));
                }
                RepositoryService repository = this.repositoryContext.getRepository();
                resource = (FileResource)repository.getResource(this.repositoryContext.getExecutionContext(), path);
                while (resource.isReference()) {
                    resource = (FileResource)repository.getResource(this.repositoryContext.getExecutionContext(), resource.getReferenceURI());
                }
                if (resource.getFileType().equals("jrxml")) {
                    data = this.repositoryContext.getCompiledReportProvider().getCompiledReport(this.repositoryContext.getExecutionContext(), path);
                } else {
                    FileResourceData resourceData = repository.getResourceData(this.repositoryContext.getExecutionContext(), path);
                    data = resourceData.getDataStream();
                }
            }
            return data;
        }
        catch (JSResourceNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

