/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling;

import com.jaspersoft.jasperserver.api.JSValidationException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportJobValidator;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportJobsInternalService;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportSchedulingInternalService;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobIdHolder;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRuntimeInformation;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsPersistenceService;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsScheduler;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulerListener;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class ReportSchedulingFacade
implements ReportSchedulingService,
ReportSchedulingInternalService,
ReportSchedulerListener,
InitializingBean {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$engine$scheduling$ReportSchedulingFacade == null ? (class$com$jaspersoft$jasperserver$api$engine$scheduling$ReportSchedulingFacade = ReportSchedulingFacade.class$("com.jaspersoft.jasperserver.api.engine.scheduling.ReportSchedulingFacade")) : class$com$jaspersoft$jasperserver$api$engine$scheduling$ReportSchedulingFacade));
    private ReportJobsPersistenceService persistenceService;
    private ReportJobsInternalService jobsInternalService;
    private ReportJobsScheduler scheduler;
    private ReportJobValidator validator;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$engine$scheduling$ReportSchedulingFacade;

    public ReportJobsPersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(ReportJobsPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public ReportJobsScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ReportJobsScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public ReportJobValidator getValidator() {
        return this.validator;
    }

    public void setValidator(ReportJobValidator validator) {
        this.validator = validator;
    }

    public ReportJobsInternalService getJobsInternalService() {
        return this.jobsInternalService;
    }

    public void setJobsInternalService(ReportJobsInternalService jobsInternalService) {
        this.jobsInternalService = jobsInternalService;
    }

    public void afterPropertiesSet() throws Exception {
        this.getScheduler().addReportSchedulerListener((ReportSchedulerListener)this);
    }

    public ReportJob scheduleJob(ExecutionContext context, ReportJob job) {
        this.validate(context, job);
        ReportJob savedJob = this.persistenceService.saveJob(context, job);
        this.scheduler.scheduleJob(context, savedJob);
        return savedJob;
    }

    protected void validate(ExecutionContext context, ReportJob job) {
        ValidationErrors errors = this.validator.validateJob(context, job);
        if (errors.isError()) {
            throw new JSValidationException(errors);
        }
    }

    public List getScheduledJobs(ExecutionContext context, String reportUnitURI) {
        List jobs = this.persistenceService.listJobs(context, reportUnitURI);
        this.setSummaryRuntimeInformation(context, jobs);
        return jobs;
    }

    public List getScheduledJobs(ExecutionContext context) {
        List jobs = this.persistenceService.listJobs(context);
        this.setSummaryRuntimeInformation(context, jobs);
        return jobs;
    }

    protected void setSummaryRuntimeInformation(ExecutionContext context, List jobs) {
        if (jobs != null && !jobs.isEmpty()) {
            long[] jobIds = new long[jobs.size()];
            int idx = 0;
            Iterator it = jobs.iterator();
            while (it.hasNext()) {
                ReportJobSummary job = (ReportJobSummary)it.next();
                jobIds[idx] = job.getId();
                ++idx;
            }
            ReportJobRuntimeInformation[] runtimeInfos = this.scheduler.getJobsRuntimeInformation(context, jobIds);
            idx = 0;
            Iterator it2 = jobs.iterator();
            while (it2.hasNext()) {
                ReportJobSummary job = (ReportJobSummary)it2.next();
                job.setRuntimeInformation(runtimeInfos[idx]);
                ++idx;
            }
        }
    }

    public void removeScheduledJob(ExecutionContext context, long jobId) {
        this.deleteJob(context, jobId);
    }

    public void removeScheduledJobs(ExecutionContext context, long[] jobIds) {
        for (int i = 0; i < jobIds.length; ++i) {
            long jobId = jobIds[i];
            this.deleteJob(context, jobId);
        }
    }

    public void removeReportUnitJobs(String reportUnitURI) {
        long[] deletedJobIds = this.getJobsInternalService().deleteReportUnitJobs(reportUnitURI);
        this.unscheduleJobs(deletedJobIds);
    }

    protected void unscheduleJobs(long[] deletedJobIds) {
        if (deletedJobIds != null && deletedJobIds.length > 0) {
            for (int i = 0; i < deletedJobIds.length; ++i) {
                long jobId = deletedJobIds[i];
                this.scheduler.removeScheduledJob(null, jobId);
            }
        }
    }

    protected void deleteJob(ExecutionContext context, long jobId) {
        this.scheduler.removeScheduledJob(context, jobId);
        this.persistenceService.deleteJob(context, new ReportJobIdHolder(jobId));
    }

    public ReportJob getScheduledJob(ExecutionContext context, long jobId) {
        return this.persistenceService.loadJob(context, new ReportJobIdHolder(jobId));
    }

    public void reportJobFinalized(long jobId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Job " + jobId + " finalized, deleting data"));
        }
        this.getJobsInternalService().deleteJob(jobId);
    }

    public void updateScheduledJob(ExecutionContext context, ReportJob job) {
        this.validate(context, job);
        ReportJobTrigger origTrigger = job.getTrigger();
        long origTriggerId = origTrigger.getId();
        int origTriggerVersion = origTrigger.getVersion();
        ReportJob savedJob = this.persistenceService.updateJob(context, job);
        ReportJobTrigger updatedTrigger = savedJob.getTrigger();
        if (updatedTrigger.getId() != origTriggerId || updatedTrigger.getVersion() != origTriggerVersion) {
            this.scheduler.rescheduleJob(context, savedJob);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Trigger attributes not changed for job " + job.getId() + ", the job will not be rescheduled"));
        }
    }

    public ValidationErrors validateJob(ExecutionContext context, ReportJob job) {
        ValidationErrors errors = this.validator.validateJob(context, job);
        if (!this.hasTriggerErrors(errors)) {
            this.scheduler.validate(job, errors);
        }
        return errors;
    }

    protected boolean hasTriggerErrors(ValidationErrors errors) {
        boolean triggerError = false;
        Iterator it = errors.getErrors().iterator();
        while (!triggerError && it.hasNext()) {
            ValidationError error = (ValidationError)it.next();
            String field = error.getField();
            if (field == null || !field.equals("trigger") && !field.startsWith("trigger.")) continue;
            triggerError = true;
        }
        return triggerError;
    }

    public ReportJob saveJob(ExecutionContext context, ReportJob job) {
        this.validate(context, job);
        ReportJob savedJob = this.jobsInternalService.saveJob(context, job, false);
        this.scheduler.scheduleJob(context, savedJob);
        return savedJob;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

