/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.hibernate;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportJobsInternalService;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobIdHolder;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobNotFoundException;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsPersistenceService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class HibernateReportJobsPersistenceService
extends HibernateDaoImpl
implements ReportJobsPersistenceService,
ReportJobsInternalService {
    protected static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$engine$scheduling$hibernate$HibernateReportJobsPersistenceService == null ? (class$com$jaspersoft$jasperserver$api$engine$scheduling$hibernate$HibernateReportJobsPersistenceService = HibernateReportJobsPersistenceService.class$("com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.HibernateReportJobsPersistenceService")) : class$com$jaspersoft$jasperserver$api$engine$scheduling$hibernate$HibernateReportJobsPersistenceService));
    private SecurityContextProvider securityContextProvider;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$engine$scheduling$hibernate$HibernateReportJobsPersistenceService;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$engine$scheduling$hibernate$PersistentReportJob;

    public SecurityContextProvider getSecurityContextProvider() {
        return this.securityContextProvider;
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    public ReportJob saveJob(ExecutionContext context, ReportJob job) {
        return this.saveJob(context, job, true);
    }

    public ReportJob saveJob(ExecutionContext context, final ReportJob job, final boolean setContextUsername) {
        return (ReportJob)this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateTemplate hibernateTemplate = HibernateReportJobsPersistenceService.this.getHibernateTemplate();
                PersistentReportJob persistentJob = new PersistentReportJob();
                persistentJob.copyFrom(job, hibernateTemplate);
                String username = setContextUsername ? HibernateReportJobsPersistenceService.this.getContextUsername() : job.getUsername();
                persistentJob.setUsername(username);
                persistentJob.cascadeSave(hibernateTemplate);
                hibernateTemplate.save((Object)persistentJob);
                hibernateTemplate.flush();
                ReportJob clientJob = persistentJob.toClient();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Saved report job " + clientJob.getId() + " for report " + clientJob.getSource().getReportUnitURI()));
                }
                return clientJob;
            }
        });
    }

    protected String getContextUsername() {
        return this.getSecurityContextProvider().getContextUsername();
    }

    public ReportJob updateJob(ExecutionContext context, final ReportJob job) {
        return (ReportJob)this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateTemplate hibernateTemplate = HibernateReportJobsPersistenceService.this.getHibernateTemplate();
                PersistentReportJob persistentJob = HibernateReportJobsPersistenceService.this.findJob(job.getId(), true);
                persistentJob.copyFrom(job, hibernateTemplate);
                persistentJob.cascadeSave(hibernateTemplate);
                hibernateTemplate.update((Object)persistentJob);
                hibernateTemplate.flush();
                ReportJob clientJob = persistentJob.toClient();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updated report job " + clientJob.getId()));
                }
                return clientJob;
            }
        });
    }

    public ReportJob loadJob(ExecutionContext context, ReportJobIdHolder jobIdHolder) {
        final long jobId = jobIdHolder.getId();
        return (ReportJob)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                PersistentReportJob persistentJob = HibernateReportJobsPersistenceService.this.findJob(jobId, false);
                ReportJob job = persistentJob == null ? null : persistentJob.toClient();
                return job;
            }
        });
    }

    public void deleteJob(ExecutionContext context, ReportJobIdHolder jobIdHolder) {
        this.deleteJob(jobIdHolder.getId());
    }

    public void deleteJob(final long jobId) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                PersistentReportJob job = HibernateReportJobsPersistenceService.this.findJob(jobId, false);
                if (job != null) {
                    HibernateReportJobsPersistenceService.this.deleteJob(job);
                } else if (log.isInfoEnabled()) {
                    log.info((Object)("Report job with id " + jobId + " not found for deletion"));
                }
                return null;
            }
        }, false);
    }

    public List listJobs(ExecutionContext context, final String reportUnitURI) {
        return (List)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                List persistentJobs = HibernateReportJobsPersistenceService.this.getReportUnitJobs(reportUnitURI);
                List jobs = HibernateReportJobsPersistenceService.this.toClientSummary(persistentJobs);
                return jobs;
            }
        });
    }

    public List listJobs(ExecutionContext context) {
        return (List)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                List persistentJobs = HibernateReportJobsPersistenceService.this.getAllJobs();
                List jobs = HibernateReportJobsPersistenceService.this.toClientSummary(persistentJobs);
                return jobs;
            }
        });
    }

    protected PersistentReportJob findJob(long jobId, boolean required) {
        PersistentReportJob job = (PersistentReportJob)this.getHibernateTemplate().get(class$com$jaspersoft$jasperserver$api$engine$scheduling$hibernate$PersistentReportJob == null ? (class$com$jaspersoft$jasperserver$api$engine$scheduling$hibernate$PersistentReportJob = HibernateReportJobsPersistenceService.class$("com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJob")) : class$com$jaspersoft$jasperserver$api$engine$scheduling$hibernate$PersistentReportJob, (Serializable)new Long(jobId));
        if (job == null && required) {
            throw new ReportJobNotFoundException(jobId);
        }
        return job;
    }

    public String getJobOwner(final long jobId) {
        return (String)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                PersistentReportJob persistentJob = HibernateReportJobsPersistenceService.this.findJob(jobId, true);
                return persistentJob.getUsername();
            }
        });
    }

    public long[] deleteReportUnitJobs(final String reportUnitURI) {
        return (long[])this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                List jobs = HibernateReportJobsPersistenceService.this.getReportUnitJobs(reportUnitURI);
                return HibernateReportJobsPersistenceService.this.deletePersistentJobs(jobs);
            }
        }, false);
    }

    protected void deleteJob(PersistentReportJob job) {
        job.delete(this.getHibernateTemplate());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted job " + job.getId()));
        }
    }

    protected List getReportUnitJobs(String reportUnitURI) {
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        DetachedCriteria crit = DetachedCriteria.forClass((Class)(class$com$jaspersoft$jasperserver$api$engine$scheduling$hibernate$PersistentReportJob == null ? (class$com$jaspersoft$jasperserver$api$engine$scheduling$hibernate$PersistentReportJob = HibernateReportJobsPersistenceService.class$("com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJob")) : class$com$jaspersoft$jasperserver$api$engine$scheduling$hibernate$PersistentReportJob));
        crit.add((Criterion)Restrictions.eq((String)"source.reportUnitURI", (Object)reportUnitURI));
        List persistentJobs = hibernateTemplate.findByCriteria(crit);
        return persistentJobs;
    }

    protected List getAllJobs() {
        return this.getHibernateTemplate().loadAll(class$com$jaspersoft$jasperserver$api$engine$scheduling$hibernate$PersistentReportJob == null ? (class$com$jaspersoft$jasperserver$api$engine$scheduling$hibernate$PersistentReportJob = HibernateReportJobsPersistenceService.class$("com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJob")) : class$com$jaspersoft$jasperserver$api$engine$scheduling$hibernate$PersistentReportJob);
    }

    public List toClientSummary(List persistentJobs) {
        ArrayList<ReportJobSummary> jobs = new ArrayList<ReportJobSummary>(persistentJobs.size());
        Iterator it = persistentJobs.iterator();
        while (it.hasNext()) {
            PersistentReportJob persistentJob = (PersistentReportJob)it.next();
            jobs.add(persistentJob.toSummary());
        }
        return jobs;
    }

    public long[] deletePersistentJobs(List jobs) {
        long[] jobIds;
        if (jobs == null || jobs.isEmpty()) {
            jobIds = null;
        } else {
            jobIds = new long[jobs.size()];
            int c = 0;
            Iterator it = jobs.iterator();
            while (it.hasNext()) {
                PersistentReportJob job = (PersistentReportJob)it.next();
                jobIds[c] = job.getId();
                this.deleteJob(job);
                ++c;
            }
        }
        return jobIds;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

