/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.hibernate;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobSource;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobTrigger;
import java.util.HashSet;
import java.util.Set;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class PersistentReportJob {
    private long id;
    private int version = -1;
    private String username;
    private String label;
    private String description;
    private PersistentReportJobSource source;
    private PersistentReportJobTrigger trigger;
    private String baseOutputFilename;
    private Set outputFormats = new HashSet();
    private String outputLocale;
    private PersistentReportJobMailNotification mailNotification;
    private PersistentReportJobRepositoryDestination contentRepositoryDestination;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public PersistentReportJobSource getSource() {
        return this.source;
    }

    public void setSource(PersistentReportJobSource source) {
        this.source = source;
    }

    public PersistentReportJobTrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(PersistentReportJobTrigger trigger) {
        this.trigger = trigger;
    }

    public PersistentReportJobMailNotification getMailNotification() {
        return this.mailNotification;
    }

    public void setMailNotification(PersistentReportJobMailNotification mailNotification) {
        this.mailNotification = mailNotification;
    }

    public void copyFrom(ReportJob job, HibernateTemplate hibernateTemplate) {
        if (this.getVersion() != job.getVersion()) {
            throw new JSException("jsexception.job.no.versions.match", new Object[]{new Integer(job.getVersion()), new Integer(this.getVersion())});
        }
        this.setLabel(job.getLabel());
        this.setDescription(job.getDescription());
        this.copySource(job);
        this.copyTrigger(job, hibernateTemplate);
        this.setBaseOutputFilename(job.getBaseOutputFilename());
        this.setOutputFormats(job.getOutputFormats() == null ? null : new HashSet(job.getOutputFormats()));
        this.setOutputLocale(job.getOutputLocale());
        this.copyContentRepostoryDestination(job);
        this.copyMailNotification(job, hibernateTemplate);
    }

    protected void copySource(ReportJob job) {
        if (this.getSource() == null) {
            this.setSource(new PersistentReportJobSource());
        }
        this.getSource().copyFrom(job.getSource());
    }

    protected void copyTrigger(ReportJob job, HibernateTemplate hibernateTemplate) {
        ReportJobTrigger jobTrigger = job.getTrigger();
        PersistentReportJobTrigger persistentTrigger = this.getTrigger();
        if (persistentTrigger != null && !persistentTrigger.supports(jobTrigger.getClass())) {
            hibernateTemplate.delete((Object)persistentTrigger);
            persistentTrigger = null;
        }
        if (persistentTrigger == null) {
            if (jobTrigger instanceof ReportJobSimpleTrigger) {
                persistentTrigger = new PersistentReportJobSimpleTrigger();
            } else if (jobTrigger instanceof ReportJobCalendarTrigger) {
                persistentTrigger = new PersistentReportJobCalendarTrigger();
            } else {
                String quotedJobTrigger = "\"" + jobTrigger.getClass().getName() + "\"";
                throw new JSException("jsexception.job.unknown.trigger.type", new Object[]{quotedJobTrigger});
            }
            this.setTrigger(persistentTrigger);
        }
        persistentTrigger.copyFrom(jobTrigger);
    }

    protected void copyContentRepostoryDestination(ReportJob job) {
        if (this.getContentRepositoryDestination() == null) {
            this.setContentRepositoryDestination(new PersistentReportJobRepositoryDestination());
        }
        this.getContentRepositoryDestination().copyFrom(job.getContentRepositoryDestination());
    }

    protected void copyMailNotification(ReportJob job, HibernateTemplate hibernateTemplate) {
        ReportJobMailNotification jobMail = job.getMailNotification();
        PersistentReportJobMailNotification persistentMail = this.getMailNotification();
        if (jobMail == null) {
            if (persistentMail != null) {
                hibernateTemplate.delete((Object)persistentMail);
                this.setMailNotification(null);
            }
        } else {
            if (persistentMail == null) {
                persistentMail = new PersistentReportJobMailNotification();
                this.setMailNotification(persistentMail);
            }
            persistentMail.copyFrom(jobMail);
        }
    }

    public ReportJob toClient() {
        ReportJob job = new ReportJob();
        job.setId(this.getId());
        job.setVersion(this.getVersion());
        job.setUsername(this.getUsername());
        job.setLabel(this.getLabel());
        job.setDescription(this.getDescription());
        job.setSource(this.getSource().toClient());
        job.setTrigger(this.getTrigger().toClient());
        job.setBaseOutputFilename(this.getBaseOutputFilename());
        job.setOutputFormats((Set)(this.getOutputFormats() == null ? null : new HashSet(this.getOutputFormats())));
        job.setOutputLocale(this.getOutputLocale());
        job.setContentRepositoryDestination(this.getContentRepositoryDestination().toClient());
        job.setMailNotification(this.getMailNotification() == null ? null : this.getMailNotification().toClient());
        return job;
    }

    public ReportJobSummary toSummary() {
        ReportJobSummary job = new ReportJobSummary();
        job.setId(this.getId());
        job.setVersion(this.getVersion());
        job.setReportUnitURI(this.getSource().getReportUnitURI());
        job.setUsername(this.getUsername());
        job.setLabel(this.getLabel());
        return job;
    }

    public PersistentReportJobRepositoryDestination getContentRepositoryDestination() {
        return this.contentRepositoryDestination;
    }

    public void setContentRepositoryDestination(PersistentReportJobRepositoryDestination contentRepositoryDestination) {
        this.contentRepositoryDestination = contentRepositoryDestination;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getBaseOutputFilename() {
        return this.baseOutputFilename;
    }

    public void setBaseOutputFilename(String baseOutputFilename) {
        this.baseOutputFilename = baseOutputFilename;
    }

    public Set getOutputFormats() {
        return this.outputFormats;
    }

    public void setOutputFormats(Set outputFormats) {
        this.outputFormats = outputFormats;
    }

    public boolean isNew() {
        return this.getVersion() == -1;
    }

    public void cascadeSave(HibernateTemplate hibernateTemplate) {
        if (this.getTrigger().isNew()) {
            hibernateTemplate.save((Object)this.getTrigger());
        }
        if (this.getContentRepositoryDestination() != null && this.getContentRepositoryDestination().isNew()) {
            hibernateTemplate.save((Object)this.getContentRepositoryDestination());
        }
        if (this.getMailNotification() != null && this.getMailNotification().isNew()) {
            hibernateTemplate.save((Object)this.getMailNotification());
        }
    }

    public void delete(HibernateTemplate hibernateTemplate) {
        hibernateTemplate.delete((Object)this);
        hibernateTemplate.delete((Object)this.getTrigger());
        if (this.getContentRepositoryDestination() != null) {
            hibernateTemplate.delete((Object)this.getContentRepositoryDestination());
        }
        if (this.getMailNotification() != null) {
            hibernateTemplate.delete((Object)this.getMailNotification());
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getOutputLocale() {
        return this.outputLocale;
    }

    public void setOutputLocale(String outputLocale) {
        this.outputLocale = outputLocale;
    }
}

